% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conductance.R
\encoding{UTF-8}
\name{CO2_conductance}
\alias{CO2_conductance}
\alias{.get_gtc}
\alias{.get_guc}
\alias{.get_gbc}
\alias{.get_gmc}
\alias{.get_gsc}
\title{Conductance to CO2 (mol / m^2 / s)}
\usage{
.get_gtc(pars, unitless, use_legacy_version)

.get_guc(pars, surface, unitless)

.get_gbc(pars, surface, unitless, use_legacy_version)

.get_gmc(pars, surface, unitless)

.get_gsc(pars, surface, unitless)
}
\arguments{
\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should \code{units} be set? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}

\item{use_legacy_version}{Logical. Should legacy model (<2.1.0) be used? See \href{https://github.com/cdmuir/photosynthesis/blob/master/NEWS.md}{NEWS} for further information. Default is FALSE.}

\item{surface}{Leaf surface (lower or upper)}
}
\description{
Conductance to CO2 (mol / m^2 / s)

\itemize{
\item g_tc: total conductance to CO2
}

\itemize{
\item g_uc: cuticular conductance to CO2
}

\itemize{
\item g_bc: boundary layer conductance to CO2
}

\itemize{
\item g_mc: mesophyll conductance to CO2
}

\itemize{
\item g_sc: stomatal conductance to CO2
}
}
\details{
\strong{Default conductance model}

The conductance model described in this section is used by default unless
additional anatomical parameters described in the next section are provided.

Total conductance to CO2 is the sum of parallel conductances on the lower
(\eqn{g_\mathrm{c,lower}}{gc_lower}) and upper
(\eqn{g_\mathrm{c,upper}}{gc_upper}) leaf portions:

\deqn{g_\mathrm{c,total} = g_\mathrm{c,lower} + g_\mathrm{c,upper}}{gc_total = gc_lower + gc_upper}

Each partial conductance consists of two parallel conductances, the
cuticular conductance (\eqn{g_\mathrm{u,c}}{g_uc}) and the in-series
conductances through mesophyll (\eqn{g_\mathrm{m,c}}{g_mc}), stomata (\eqn{g_\mathrm{s,c}}{g_sc}), and boundary layer (\eqn{g_\mathrm{b,c}}{g_bc}). To simplify the formula, I use substitute resistance where \eqn{r_x = 1 / g_x}. For surface \eqn{i}:

\deqn{g_{\mathrm{c},i} = g_{\mathrm{u},i} + (1 / (r_{\mathrm{m},i} + r_{\mathrm{s},i} + r_{\mathrm{b},i}))}{g_ci = g_ui + (1 / (r_mi + r_si + r_bi))}

The cuticular, stomatal, and mesophyll conductances can be the same or
different for upper and lower. The partitioning factors (\eqn{k_x}) divide the conductance between surfaces while keeping the total conductance constant:

\deqn{g_{x,\mathrm{lower}} = g_x (1 / (1 + k_x))}{gx_lower = g_x (1 / (1 + k_x))}
\deqn{g_{x,\mathrm{upper}} = g_x (k_x / (1 + k_x))}{gx_upper = g_x (k_x / (1 + k_x))}
\deqn{g_x = g_{x,\mathrm{lower}} + g_{x,\mathrm{upper}}}{g_x = gx_lower + gx_upper}

How the partitioning factors work: \cr
\tabular{ll}{
\eqn{k_x} \tab description \cr
0 \tab all conductance on \strong{lower} surface/portion \cr
0.5 \tab 2/3 conductance on \strong{lower} surface \cr
1 \tab conductance evenly divided between surfaces/portions \cr
2 \tab 2/3 conductance on \strong{upper} surface \cr
Inf \tab all conductance on \strong{upper} surface/portion
}

The boundary layer conductances for each are calculated on the basis of mass
and heat transfer (see \code{\link[=.get_gbc]{.get_gbc()}}).

\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{g_\mathrm{mc}}{g_mc} \tab \code{g_mc} \tab mesophyll conductance to CO2 (T_leaf) \tab mol / m\eqn{^2} / s \tab \link[=bake]{calculated} \cr
\eqn{g_\mathrm{sc}}{g_sc} \tab \code{g_sc} \tab stomatal conductance to CO2 \tab mol / m\eqn{^2} / s \tab 0.4 \cr
\eqn{g_\mathrm{uc}}{g_uc} \tab \code{g_uc} \tab cuticular conductance to CO2 \tab mol / m\eqn{^2} / s \tab 0.01 \cr
\eqn{k_\mathrm{mc}}{k_mc} \tab \code{k_mc} \tab partition of \eqn{g_\mathrm{mc}}{g_mc} to lower mesophyll \tab none \tab 1 \cr
\eqn{k_\mathrm{sc}}{k_sc} \tab \code{k_sc} \tab partition of \eqn{g_\mathrm{sc}}{g_sc} to lower surface \tab none \tab 1 \cr
\eqn{k_\mathrm{uc}}{k_uc} \tab \code{k_uc} \tab partition of \eqn{g_\mathrm{uc}}{g_uc} to lower surface \tab none \tab 1 \cr
}

\strong{New conductance model}

The conductance model described in this section is implemented in
\strong{photosynthesis} (>= 2.1.0) if parameters to calculate the internal
airspace and liquid-phase conductances (\code{A_mes_A}, \code{g_liqc}) are
provided. These parameters are 1) the effective path lengths through the
lower and upper leaf internal airspaces (\code{delta_ias_lower},
\code{delta_ias_upper}) and 2) the mesophyll area per leaf area
(\code{A_mes_A}) and liquid-phase conductance per mesophyll cell area
(\code{g_liqc}).

Two parallel diffusion pathways, one from each leaf surface, converge to a
single CO2 concentration at the mesophyll cell boundary. We use a single
liquid-phase resistance to represent the combined cell wall, plasmalemma, and
chloroplast resistances. The gas-phase resistance through boundary layer,
cuticle/stomata, and internal airspace is \eqn{r_\mathrm{gas,c}}; the
liquid-phase intracellular resistance is \eqn{r_\mathrm{i,c}}.

\deqn{r_\mathrm{total,c} = r_\mathrm{gas,c} + r_\mathrm{i,c}}{r_total,c = r_gas,c + r_i,c}

The gas-phase resistance occurs through two parallel pathways, which we refer
to as the 'lower' and 'upper' pathways because horizontally oriented leaves
often have different anatomical properties on each surface. The gas-phase
resistance through pathway \eqn{i \in \{\textrm{lower,upper\}}} is:

\deqn{r_{\mathrm{gas,c},i} = r_{\mathrm{b,c},i} + r_{\mathrm{u+s,c},i} + r_{\mathrm{ias,c},i}}{r_gas,c,i = r_b,c,i + r_u+s,c,i + r_ias,c,i}

The subscripts \eqn{_\mathrm{b}}, \eqn{_\mathrm{u+s}}, and \eqn{_\mathrm{ias}}
denote boundary layer, cuticular + stomatal, and internal airspace,
respectively. The subscript \eqn{_\mathrm{c}} indicates we are considering
the conductance to CO2 rather than another molecular species.

Cuticular and stomatal conductances (1 / resistance) are parallel, so:

\deqn{1 / r_{\mathrm{u+s,c},i} = g_{\mathrm{u+s,c},i} = g_{\mathrm{u,c},i} + g_{\mathrm{s,c},i}}{1 / r_u+s,c,i = g_u+s,c,i = g_u,c,i + g_s,c,i}

Substituting the above expression into the equation for \eqn{r_{\mathrm{gas,c},i}}{r_gas,c,i}:

\deqn{r_{\mathrm{gas,c},i} = r_{\mathrm{b,c},i} + 1 / (g_{\mathrm{u,c},i} = g_{\mathrm{s,c},i}) + r_{\mathrm{ias,c},i}}{r_gas,c,i = r_b,c,i + 1 / (g_u,c,i + g_s,c,i) + r_ias,c,i}

The total gas-phase resistance is the inverse of the sum of the parallel
lower and upper conductances:

\deqn{1 / r_{\mathrm{gas,c}} = g_\mathrm{gas,c,lower} + g_\mathrm{gas,c,upper}}{1 / r_gas,c = g_gas,c = g_gas,c,lower + g_gas,c,upper}

The cuticular, stomatal, and mesophyll conductances can be the same or
different for upper and lower. The partitioning factors \eqn{k_u} and \eqn{k_s}
divide the total cuticular and stomatal conductances, respectively, between
surfaces while keeping the total conductance constant:

\deqn{g_{x,\mathrm{lower}} = g_x (1 / (1 + k_x))}{gx_lower = g_x (1 / (1 + k_x))}
\deqn{g_{x,\mathrm{upper}} = g_x (k_x / (1 + k_x))}{gx_upper = g_x (k_x / (1 + k_x))}
\deqn{g_x = g_{x,\mathrm{lower}} + g_{x,\mathrm{upper}}}{g_x = gx_lower + gx_upper}

How the partitioning factors work: \cr
\tabular{ll}{
\eqn{k_x} \tab description \cr
0 \tab all conductance on \strong{lower} surface/portion \cr
0.5 \tab 2/3 conductance on \strong{lower} surface \cr
1 \tab conductance evenly divided between surfaces/portions \cr
2 \tab 2/3 conductance on \strong{upper} surface \cr
Inf \tab all conductance on \strong{upper} surface/portion
}

The internal airspace conductance is the diffusivity of CO2 at a given
temperature and pressure divided by the effective path length:

\deqn{g_\mathrm{ias,c,lower} = D_\mathrm{c} / \delta_\mathrm{ias,lower}}{g_iasc_lower = D_c / delta_ias_lower}
\deqn{g_\mathrm{ias,c,upper} = D_\mathrm{c} / \delta_\mathrm{ias,upper}}{g_iasc_ipper = D_c / delta_ias_upper}

\code{g_iasc_lower} and \code{g_iasc_upper} are calculated in the \link{bake}
function. See \code{\link[tealeaves:dot-get_Dx]{tealeaves::.get_Dx()}} for calculating \code{D_c}.

The liquid-phase intracellular resistance is given by:

\deqn{1 / r_\mathrm{i,c} = g_\mathrm{i,c} = g_\mathrm{liq,c} A_\mathrm{mes} / A}{1 / r_i,c = g_i,c = g_liq,c A_mes / A}

\eqn{g_\mathrm{liq,c}}{g_liq,c} is temperature sensitive. See \code{\link[=bake]{bake()}}.

The boundary layer conductances for each are calculated on the basis of mass
and heat transfer (see \code{\link[=.get_gbc]{.get_gbc()}}).
}
