\name{phrSetDumpStringsOn}
\alias{phrSetDumpStringsOn}
\title{Set dump strings on/off.}
\usage{
phrSetDumpStringsOn(value)
}
\arguments{
  \item{value}{if TRUE, captures output normally sent to
  the error file into a buffer.}
}
\description{
Sets the dump strings switch on or off. This switch
controls whether or not the data normally sent to the dump
file are stored in a buffer for retrieval. The initial
setting is off.
}
\examples{
# This example equilibrates pure water with calcite and echos the
# dump strings.
phrLoadDatabaseString(phreeqc.dat)
phrSetDumpStringsOn(TRUE)
input <- c(
  'SOLUTION 1 Pure water     ',
  'EQUILIBRIUM_PHASES 1      ',
  '    Calcite 0 10          ',
  'SAVE solution 1           ',
  'SAVE equilibrium_phases 1 ',
  'DUMP                      ',
  '    -solution 1           ',
  '    -equilibrium_phases 1 '
  )

if (is.null(phrRunString(input))) {
  cat("Dump:\\n")
  cat(phrGetDumpStrings(), sep = "\\n")
}
}
\references{
\url{ftp://brrftp.cr.usgs.gov/pub/charlton/iphreeqc/IPhreeqc.pdf}
}
\seealso{
Other Dump: \code{\link{phrGetDumpFileName}};
\code{\link{phrGetDumpFileOn}};
\code{\link{phrGetDumpStringsOn}};
\code{\link{phrGetDumpStrings}};
\code{\link{phrSetDumpFileName}};
\code{\link{phrSetDumpFileOn}}
}

