% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_fns.R
\name{download_fns}
\alias{download_fns}
\title{Download files from a repository}
\usage{
download_fns(df, tgtDir = NULL,
  baseDir = "https://github.com/phuse-org/phuse-scripts/raw/master")
}
\arguments{
\item{df}{a data frame containing file names produced from extract_fns}

\item{tgtDir}{target directory for storing the files}

\item{baseDir}{base directory in the repository including the repo URL.
Default to "https://github.com/phuse-org/phuse-scripts/raw/master"}
}
\description{
download files defined in the input data frame.
}
\examples{
\dontrun{
  a <- "https://github.com/phuse-org/phuse-scripts/raw/master"
  b <- "development/R/scripts"
  c <- "Draw_Dist2_R.yml"
  f1 <- paste(a,b,c, sep = '/')
  f2 <- read_yml(f1)
  f3 <- extract_fns(f2)
  f4 <- download_fns(f3)
}
}
\author{
Hanming Tu
}
