% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cherries.R
\name{cherries}
\alias{cherries}
\title{Cherry number}
\usage{
cherries(tree, normalise = FALSE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result, default is \code{FALSE}.}
}
\value{
An integer representing the number of cherries in the tree.
}
\description{
Finds the number of cherries in a tree. A cherry is considered to be a pair of sister tips.
}
\examples{
## Find the number of cherries in a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
cherries(tree)
# and the normalised cherry number:
cherries(tree, normalise=TRUE)

## Note that the function configShow can be used to highlight the cherries in the tree:
configShow(tree, 2, edge.width=2)


}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\seealso{
\code{\link{configShow}}
}

