% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colless.R
\name{colless.phylo}
\alias{colless.phylo}
\title{Colless number}
\usage{
colless.phylo(tree, normalise = TRUE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result by dividing by the number of tip pairs. Defaults to \code{TRUE}.}
}
\value{
The Colless imbalance number of the tree.
}
\description{
Finds the Colless number for a tree.
Note that the package \code{apTreeshape} has a function \code{colless} to compute the Colless imbalance with additional options to normalise it based on the model;
we include this simple function here for convenience within this package, and for use on objects of class \code{phylo} and \code{phylo4}.
}
\examples{
## Find the Colless imbalance of a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
colless.phylo(tree)


}
\author{
Michael Boyd \email{mboyd855@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

