% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxapair.vcv.R
\name{taxapair.vcv}
\alias{taxapair.vcv}
\title{taxapair.vcv}
\usage{
taxapair.vcv(sp.pairs, tree, spnames=FALSE, dec=2, model="sq.diff", 
  regularize=FALSE, regparam=NULL)
}
\arguments{
\item{sp.pairs}{A table (matrix or data.frame) in which the first column contains the names of 'species 1' and the second column contains the names of 'species 2'. Names must be in the same format used in the phylogenetic tree.}

\item{tree}{An ultrametric phylogenetic tree ('phylo' object) containing species that appear in the dataset (as either a species 1 or species 2 or both).}

\item{spnames}{Logical determining whether to use species names as row and column labels for matrix. If TRUE, then the name of a row or column will be in the form "species1_species2". If FALSE, names are formed from the indices of the species names in the tree "indexOfSpecies1_indexOfSpecies2". Defaults to FALSE.}

\item{dec}{Number of decimal places to round the values in the matrix; defaults to 2.}

\item{model}{One of 'sq.diff', 'sq.sum', 'simple.sum', and 'product'. Defaults to 'sq.diff'. See details.}

\item{regularize}{Logical indicating whether regularization should be used if resulting matrix is numerically singular; defaults to FALSE. If TRUE, regularization is conducted by adding a small value to the diagonal of the matrix. By default, this value is equal to 1\% of the median value on the diagonal, which is continually added until matrix is no longer numerically singular.}

\item{regparam}{Custom regularization parameter. Instead of adding the default 1\% of the median diagonal value to the diagonal, it will add regparam * that median value. IMPORTANT: it only does this once and does not continue adding the number until the matrix is non-singular. For 2\%, write 0.02; for 10\%, write 0.10, and so on.}
}
\value{
A lineage-pair covariance matrix.
}
\description{
Calculates an unscaled lineage-pair covariance matrix for use in
downstream analyses.
}
\details{
Just as the traits of different species are not independent due to varying
amounts of shared evolutionary history, so too are pairwise-defined traits like
'strength of RI' and 'range overlap' not independent among related taxonomic pairs.
The function \code{taxapair.vcv()} calculates the expected covariance structure for
lineage-pair datasets given the taxa in each pair and a phylogenetic tree
(containing the taxa that appear in the dataset). The exact structure of this
covariance depends on the underlying model by which phylogenetic signal among
taxa is expected to translate into non-independence among taxonomic pairs
(Anderson et al. \emph{in review}).

Let X be some underlying continuous biological character (or set of characters)
that is defined for each taxon and that has phylogenetic signal. Users can choose
one of four models by which signal in X generates covariance among pairs in a
lineage-pair trait:
\enumerate{
\item sq.diff (default) -- the lineage-pair trait is influenced by the absolute
difference between the two taxa in X.
\item sq.sum -- the lineage-pair trait is linearly by the squared sum of
the value of X in each taxon.
\item simple.sum -- the lineage-pair trait is influenced by the sum of the
the value of X in each taxon. IMPORTANT: this model tends to result in
a singular matrix.
\item product -- the lineage-pair trait is influenced by the product of the
the value of X in each taxon.
}

In each case, it is assumed that there is a linear relationship between
the value calculated in each model and the response variable.
}
\examples{
library(ape)
# Load simulated dataset and tree
data(data1)
data(sim.tree1)
# Calculate the lineage-pair covariance matrix
linpair.mat = taxapair.vcv(sp.pairs=data1[,1:2], tree=sim.tree1)
dim(linpair.mat)
# Check the validity of the matrix
covmat.check(linpair.mat)
}
\references{
Anderson, S. A. S., et al. \emph{In review}. The comparative analysis of lineage-pair data.
}
