% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopath.R
\name{phylo_path_binary}
\alias{phylo_path_binary}
\title{Compare binary causal models in a phylogenetic context.}
\usage{
phylo_path_binary(models, data, tree, order = NULL, parallel = NULL,
  na.rm = TRUE)
}
\arguments{
\item{models}{A list of directed acyclic graphs. These are matrices,
typically created with \code{DAG}.}

\item{data}{A \code{data.frame} with binary data. Variables can be a numeric vector (with all
values either 0 or 1), a factor (with two levels) or character vector (with two unique values).}

\item{tree}{A phylogenetic tree of class \code{pylo}.}

\item{order}{Causal order of the included variable, given as a character
vector. This is used to determine which variable should be the dependent
in the dsep regression equations. If left unspecified, the order will be
automatically determined. If the combination of all included models is
itself a DAG, then the ordering of that full model is used. Otherwise,
the most common ordering between each pair of variables is used to create
a general ordering.}

\item{parallel}{An optional vector containing the virtual connection
process type for running the chains in parallel (such as \code{"SOCK"}).
A cluster is create using the \code{parallel} package.}

\item{na.rm}{Should rows that contain missing values be dropped from the data
as necessary (with a message)?}
}
\value{
A phylopath_binary object, with the following components:
 \describe{
  \item{d_sep}{for each model a table with separation statements and statistics.}
  \item{models}{the DAGs}
  \item{data}{the supplied data}
  \item{tree}{the supplied tree}
  }
}
\description{
Compare binary causal models in a phylogenetic context.
}
\details{
Estimation of relationships between binary variables is built upon
  \code{ape::binaryPGLMM} and stands or falls with the accuracy of that method. Model fitting
  using this method is particularly slow and the \code{parallel} argument can therefore be
  especially useful.
}
