% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopath.R
\name{choice}
\alias{choice}
\title{Extract and estimate an arbitrary model from a phylogenetic path analysis.}
\usage{
choice(phylopath, choice, ...)
}
\arguments{
\item{phylopath}{An object of class \code{phylopath}.}

\item{choice}{A character string of the name of the model to be chosen, or
the index in \code{model_set}.}

\item{...}{Arguments to pass to \link[phylolm:phylolm]{phylolm::phylolm} and \link[phylolm:phyloglm]{phylolm::phyloglm}. If you specified
options in the original \link{phylo_path} call you don't need to specify them again.}
}
\value{
An object of class \code{fitted_DAG}.
}
\description{
Extract and estimate an arbitrary model from a phylogenetic path analysis.
}
\examples{
  candidates <- define_model_set(
    A = NL ~ BM,
    B = NL ~ LS,
    .common = c(LS ~ BM, DD ~ NL)
  )
  p <- phylo_path(candidates, rhino, rhino_tree)
  my_model <- choice(p, "B")
  # Print the best model to see coefficients, se and ci:
  my_model
  # Plot to show the weighted graph:
  plot(my_model)

}
