% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.pe.ses.R
\name{.rast.pe.B}
\alias{.rast.pe.B}
\title{Calculate phylogenetic endemism for a raster}
\usage{
.rast.pe.B(x, inv.R, branch.length, filename = "", ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{inv.R}{SpatRaster. Inverse of range size. See \code{\link{inv.range}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculate phylogenetic endemism using rasters as input and output.
}
\references{
Rosauer, D. A. N., Laffan, S. W., Crisp, M. D., Donnellan, S. C.,
& Cook, L. G. (2009). Phylogenetic endemism: a new approach for identifying
geographical concentrations of evolutionary history. Molecular ecology,
18(19), 4061-4072.
}
\keyword{internal}
