\name{hcreorder}
\alias{hcreorder}
\title{
Reorder the height for hclust object
}
\description{
This function could be used to reorder the height values in hclust objects, especially when the hclust object was generated by \code{as.hclust.phylo()} in package ape. Since the method \code{rect.hclust()} or \code{cutree()} could not be applied to the hclust objected generated by ape before the height of the nodes be sorted in a increase order. 
}
\usage{
hcreorder(x)
}

\arguments{
  \item{x}{ object in class hclust.
}
}
\details{
It should be note that if the height of the nodes are not sorted in increasing order, the \code{rect.hclust()} or \code{cutree()} will give wrong results. If the hclust object is generated by \code{hclust()} on distance matrix, there is no need to call this function. However, as hclust object was specified manually, or if generated using ape from a phylogenetic tree using as.hclust.phylo, you may have to call hcreorder first to reorder the heights of nodes. It should be noted that the merge matrix in hclust has also been regenerated according the definition of hclust object.
}
\value{
hclust object with heights been reordered
}
\references{
None.
}
\author{
Jinlong Zhang \email{jinlongzhang01@gmail.com}
}

\seealso{
\code{\link{hclust}},\code{\link{cutree}},\code{\link{rect.hclust}}
}
\examples{

### help file for hreorder()
### load ape library

library(ape)
data(bird.orders)
### convert the bird.orders to class hclust
bird.hclust <- as.hclust(multi2di(bird.orders))

### ready to draw tree/dendrograms
par(mfrow = c(1,3))

### plot phylogenetic tress
plot(bird.orders, direction = "downwards", cex = 1.5)


### the wrong results, because of the unordered height in hclust
### plot the bird.hclust
plot(bird.hclust, hang = -1 )

### add rectangles to the plot 
rect.hclust(bird.hclust, k = 4)


### the proper results.

### reorder the hclust object
bird.hclust.ordered <- hcreorder(bird.hclust)
### plot the reordered hclust object
plot(bird.hclust.ordered, hang = -1 )

### add rectangles to the plot 
rect.hclust(bird.hclust.ordered, k = 4)


### call cutree to divide the taxon to groups/clades 
cutree(bird.hclust.ordered, k = 4)

## Not run
}

\keyword{ hclust }

