% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piece-rayrender.R
\name{piece}
\alias{piece}
\title{Create rayrender board game piece objects}
\usage{
piece(
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  x = 0,
  y = 0,
  z = NA,
  angle = 0,
  axis_x = 0,
  axis_y = 0,
  width = NA,
  height = NA,
  depth = NA,
  envir = getOption("piecepackr.envir"),
  ...,
  scale = 1,
  res = 72
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{axis_x}{First coordinate of the axis unit vector.}

\item{axis_y}{Second coordinate of the axis unit vector.}

\item{width}{Width of piece (plus bleed if \code{bleed} is \code{TRUE})}

\item{height}{Height of piece (plus bleed if \code{bleed} is \code{TRUE})}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{...}{Ignored.}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{res}{Resolution of the faces.}
}
\value{
A rayrender object.
}
\description{
\code{piece} creates 3d board game piece objects for use with the rayrender package.
}
\examples{
  \donttest{
    if (require("rayrender")) {
        cfg <- game_systems("sans3d")$piecepack
        render_scene(piece("tile_face", suit = 3, rank = 3, cfg = cfg))
        render_scene(piece("coin_back", suit = 4, rank = 2, cfg = cfg))
        render_scene(piece("pawn_face", suit = 2, cfg = cfg))
    }
  }
}
\seealso{
See \url{https://www.rayrender.net} for more information about the \code{rayrender} package.
See \code{\link{geometry_utils}} for a discussion of the 3D rotation parameterization.
}
