% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\docType{class}
\name{GermlineCluster-class}
\alias{GermlineCluster-class}
\alias{GermlineCluster}
\alias{plot,GermlineCluster,missing-method}
\alias{plot,GermlineCluster,missing,}
\alias{numeric}
\title{Output of inferAlleleClusters}
\usage{
\S4method{plot}{GermlineCluster,missing}(x, y = NULL, cex = 1, seed = 9999)
}
\arguments{
\item{x}{GermlineCluster object}

\item{y}{not in use. missing.}

\item{cex}{Controls the size of the allele label. Default is 1.}

\item{seed}{Set a seed number for drawing the dendrogram. Default 9999.}
}
\description{
\code{GermlineCluster} contains output from \link{inferAlleleClusters} function.
It includes the allele cluster table, the germline set hierarchical clustering,
and the threshold parameters.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = GermlineCluster, y = missing)}: Plot the dendrogram for the allele clusters.

}}
\section{Slots}{

\describe{
\item{\code{germlineSet}}{the original germline set provided}

\item{\code{alleleClusterSet}}{the renamed germline set with the allele clusters}

\item{\code{alleleClusterTable}}{the allele cluster table}

\item{\code{hclustAlleleCluster}}{the hierarchical clustering object of the germline set.}

\item{\code{threshold}}{the threshold used for the family and the allele clusters.}
}}

\seealso{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ \link{inferAlleleClusters}
}\if{html}{\out{</div>}}
}
