% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/showOddsDF.R
\name{showOddsDF}
\alias{showOddsDF}
\title{showOddsDF - Takes a GetOdds JSON response and turns it into a data.frame}
\usage{
showOddsDF(sportname, leagueIds = NULL, since = NULL, isLive = 0,
  attachLeagueNames = TRUE, force = TRUE)
}
\arguments{
\item{sportname}{The sport name for which to retrieve the fixutres}

\item{leagueIds}{numeric vector of leagueids - can get as output from GetLeagues}

\item{since}{numeric This is used to receive incremental updates.
Use the value of last from previous fixtures response.}

\item{isLive}{boolean if TRUE retrieves ONLY live events}

\item{attachLeagueNames}{boolean default set to true, will attach league names.}

\item{force}{boolean default set to TRUE, forces a reload of the cache.
bettable leagues}
}
\value{
a dataframe combining GetOdds and GetFixtures data, containing NA's where levels of factors do not have a value.
Naming convention is as follows, Example: spread.altLineId.N is the altLineId associated with spread.hdp.(N+1)
whereas spread.hdp refers to the mainline. spread.altLineId is the first alternate, and equivalent to spread.altLineId.0
}
\description{
showOddsDF - Takes a GetOdds JSON response and turns it into a data.frame
}
\examples{
\donttest{
SetCredentials("TESTAPI","APITEST")
AcceptTermsAndConditions(accepted=TRUE)
showOddsDF(sportname="Badminton",leagueIds=191545)}
}

