% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_browse.R
\name{pin_browse}
\alias{pin_browse}
\title{Browse source of a pin}
\usage{
pin_browse(board, name, version = NULL, local = FALSE)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[=pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{local}{If \code{TRUE}, will open the local copy of the pin; otherwise
will show you the home of the pin on the internet.}
}
\description{
\code{pin_browse()} navigates you to the home of a pin, either on the
internet or on your local file system.
}
\examples{
board <- board_temp(versioned = TRUE)
board \%>\% pin_write(1:10, "x")
board \%>\% pin_write(1:11, "x")
board \%>\% pin_write(1:12, "x")

board \%>\% pin_browse("x", local = TRUE)
}
