% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_twal_with_uns_site_model.R
\name{sim_twal_with_uns_nsm}
\alias{sim_twal_with_uns_nsm}
\title{Adapter function to simulate an alignment
with the \code{linked_node_sub} (lns) site model.}
\usage{
sim_twal_with_uns_nsm(
  twin_phylogeny,
  root_sequence,
  true_alignment = "irrelevant",
  branch_subst_matrix = rep(1, 6),
  node_subst_matrix = 1,
  branch_mutation_rate = 1,
  node_mutation_rate = 1,
  base_frequencies = rep(0.25, 4),
  node_time = 0.001
)
}
\arguments{
\item{twin_phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{true_alignment}{a DNA alignment, of class \link[ape]{DNAbin}}

\item{branch_subst_matrix}{substitution matrix along the branches.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{node_subst_matrix}{substitution matrix on the nodes.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{branch_mutation_rate}{mutation rate along the branch.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{node_mutation_rate}{mutation rate on the node.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{base_frequencies}{the four base frequencies (a, c, g, t) to be
specified to create the rate matrix (i.e. Q matrix)
used to simulate alignments}

\item{node_time}{amount of time spent at the nodes.
See, among others, \link[nodeSub]{sim_unlinked} for more details}
}
\value{
an alignment of type \code{DNAbin}
}
\description{
Adapter function to simulate an alignment
with the \code{linked_node_sub} (lns) site model.
}
\seealso{
Use \link{sim_twal_with_lns_nsm}
to simulate the true alignment with a linked node substitution model.
Use \link{sim_tral_with_uns_nsm}
to simulate the twin alignment with an unlinked node substitution model.
}
\author{
Richèl J.C. Bilderbeek
}
