% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_tree2brts}
\alias{convert_tree2brts}
\title{Convert a tree into branching times}
\usage{
convert_tree2brts(tree, precision = 8)
}
\arguments{
\item{tree}{an ultrametric phylogenetic tree of class \link[ape]{phylo}}

\item{precision}{define the precision of the approximation.}
}
\value{
the branching times
}
\description{
Convert a tree into branching times.
Differently from the \link[ape]{branching.times} function in \link{ape},
it will keep the multiple events. Since the units are million
years, a precision of 8 means that the approximation goes up to the 8-th
digits. With such approximation we consider events happening within an
interval of 4 days (1 million years / 10^8 = 1 year / 100) as simultaneous.
}
\examples{
phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")

# c(3.0, 2.0)
convert_tree2brts(phylogeny)
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
