% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_tabcolsep.R
\name{sprinkle_tabcolsep}
\alias{sprinkle_tabcolsep}
\alias{sprinkle_tabcolsep.default}
\alias{sprinkle_tabcolsep.dust_list}
\title{Change the tabcolsep Property in a Dust Table}
\source{
\url{https://www.google.com/webhp?sourceid=chrome-instant&rlz=1C1CHBF_enUS706US706&ion=1&espv=2&ie=UTF-8#q=latex+tabcolsep&*}
}
\usage{
sprinkle_tabcolsep(x, tabcolsep = getOption("pixie_tabcolsep", 6), ...)

\method{sprinkle_tabcolsep}{default}(x,
  tabcolsep = getOption("pixie_tabcolsep", 6), ...)

\method{sprinkle_tabcolsep}{dust_list}(x,
  tabcolsep = getOption("pixie_tabcolsep", 6), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{tabcolsep}{\code{numeric(1)}, integer-like value.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The \code{tabcolsep} property controls the space between 
  columns in LaTeX output.  By default, it is set to 6 pt.
}
\details{
Reading on the details of \code{tabcolsep} may be done by 
  searching "latex tabcolsep" on the internet.

This property has no effect on non-LaTeX output.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{tabcolsep} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{tabcolsep} is not integerish and length 1.
}
}

\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}
\author{
Benjamin Nutter
}
