% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_timeout}
\alias{async_timeout}
\title{Asynchronous function call with a timeout}
\usage{
async_timeout(task, timeout, ...)
}
\arguments{
\item{task}{Asynchronous function.}

\item{timeout}{Timeout as a \code{difftime} object, or number of seconds.}

\item{...}{Additional arguments to \code{task}.}
}
\value{
A deferred value. An \code{async_timeout} error is thrown if it is
not resolved within the specified timeout.
}
\description{
If the deferred value is not resolved before the timeout expires,
\code{async_timeout()} throws an \code{async_timeout} error.
}
\examples{
## You can catch the error, asynchronously
synchronise(
  async_timeout(function() delay(1/10)$then(function() "OK"), 1/1000)$
    catch(async_timeout = function(e) "Timed out",
          error = function(e) "Other error")
)

## Or synchronously
tryCatch(
  synchronise(
    async_timeout(function() delay(1/10)$then(function() "OK"), 1/1000)
  ),
  async_timeout = function(e) "Timed out. :(",
  error = function(e) paste("Other error:", e$message)
)
}
\concept{async utilities}
