% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-reference.R
\name{build_reference}
\alias{build_reference}
\alias{build_reference_index}
\title{Build reference section}
\usage{
build_reference(
  pkg = ".",
  lazy = TRUE,
  examples = TRUE,
  run_dont_run = FALSE,
  seed = 1014,
  override = list(),
  preview = NA,
  devel = TRUE,
  document = "DEPRECATED",
  topics = NULL
)

build_reference_index(pkg = ".")
}
\arguments{
\item{pkg}{Path to package.}

\item{lazy}{If \code{TRUE}, only rebuild pages where the \code{.Rd}
is more recent than the \code{.html}. This makes it much easier to
rapidly prototype. It is set to \code{FALSE} by \code{\link[=build_site]{build_site()}}.}

\item{examples}{Run examples?}

\item{run_dont_run}{Run examples that are surrounded in \\dontrun?}

\item{seed}{Seed used to initialize so that random examples are
reproducible.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{devel}{Determines how code is loaded in order to run examples.
If \code{TRUE} (the default), assumes you are in a live development
environment, and loads source package with \code{\link[pkgload:load_all]{pkgload::load_all()}}.
If \code{FALSE}, uses the installed version of the package.}

\item{document}{\strong{Deprecated} Use \code{devel} instead.}

\item{topics}{Build only specified topics. If supplied, sets \verb{lazy`` and }preview\code{to}FALSE`.}
}
\description{
By default, pkgdown will generate an index that lists all functions in
alphabetical order. To override this, provide a \code{reference} section in your
\verb{_pkgdown.yml} as described below.
}
\section{Reference index}{

To tweak the index page, add a section called \code{reference} to \verb{_pkgdown.yml}.
It can contain three different types of element:
\itemize{
\item A \strong{title} (\code{title} + \code{desc}), which generates an row containing an \verb{<h2>}
with optional paragraph description.
\item A \strong{subtitle} (\code{subtitle} + \code{desc}), which generates an row containing an
\verb{<h3>} with optional paragraph description.
\item A \strong{list of topics} (\code{contents}), which generates one row for each topic,
with a list of aliases for the topic on the left, and the topic title
on the right.
}

(For historical reasons you can include \code{contents} with a title or
subtitle, but this is no longer recommended).

Most packages will only need to use \code{title} and \code{contents} components.
For example, here's a snippet from the YAML that pkgdown uses to generate
its own reference index:\preformatted{reference:
- title: Build
  desc:  Build a complete site or its individual section components.
- contents:
  - starts_with("build_")
- title: Templates
- contents:
  - template_navbar
  - render_page
}

Bigger packages, e.g. ggplot2, may need an additional layer of
structure in order to clearly organise large number of functions:\preformatted{reference:
- title: Layers
- subtitle: Geoms
  desc: Geom is short for geometric element
- contents:
  - starts_with("geom")
- subtitle: Stats
  desc: Statistical transformations transform data before display.
  contents:
  - starts_with("stat")
}

\code{desc} can use markdown, and if you have a long description it's a good
idea to take advantage of the YAML \code{>} notation:\preformatted{desc: >
  This is a very _long_ and **overly** flowery description of a
  single simple function. By using `>`, it's easy to write a description
  that runs over multiple lines.
}
\subsection{Topic matching}{

\code{contents} can contain:
\itemize{
\item Individual function/topic names.
\item Weirdly named functions with doubled quoting, once for YAML and once for
R, e.g. \code{"`+.gg`"}.
\item \code{starts_with("prefix")} to select all functions with common prefix.
\item \code{ends_with("suffix")} to select all functions with common suffix.
\item \code{matches("regexp")} for more complex regular expressions.
\item \code{has_keyword("x")} to select all topics with keyword "x";
\code{has_keyword("datasets")} selects all data documentation.
\item \code{has_concept("blah")} to select all topics with concept "blah".
If you are using roxygen2, \code{has_concept()} also matches family tags, because
roxygen2 converts them to concept tags.
\item \code{lacks_concepts(c("concept1", "concept2"))} to select all topics
without those concepts. This is useful to capture topics not otherwise
captured by \code{has_concepts()}.
}

All functions (except for \code{has_keywords()}) automatically exclude internal
topics (i.e. those with \verb{\\keyword\{internal\}}). You can choose to include
with (e.g.) \code{starts_with("build_", internal = TRUE)}.

Use a leading \code{-} to remove topics from a section, e.g. \code{-topic_name},
\code{-starts_with("foo")}.

pkgdown will check that all non-internal topics are included on
the reference index page, and will generate a warning if you have missed any.
}

\subsection{Icons}{

You can optionally supply an icon for each help topic. To do so, you'll need
a top-level \code{icons} directory. This should contain {.png} files that are
either 30x30 (for regular display) or 60x60 (if you want retina display).
Icons are matched to topics by aliases.
}
}

\section{Figures}{


You can control the default rendering of figures by specifying the \code{figures}
field in \verb{_pkgdown.yml}. The default settings are equivalent to:\preformatted{figures:
  dev: ragg::agg_png
  dpi: 96
  dev.args: []
  fig.ext: png
  fig.width: 7.2916667
  fig.height: ~
  fig.retina: 2
  fig.asp: 1.618
  bg: NA
}
}

