% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collate.R
\name{collate}
\alias{collate}
\title{Evaluate a list of file specifications}
\usage{
collate(pkg = ".", ...)
}
\arguments{
\item{pkg}{Path to the package directory.}

\item{...}{One or more file specification objects.}
}
\value{
A file collection object containing the package name,
file paths, and file format types.
}
\description{
Evaluate a list of file specifications and bind the results
as a file collection.
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Get package metadata, for example, the package name.
    \item Flatten the input list of file specification(s).
    \item Evaluate the file specification(s) under the \code{pkg} directory.
    \item Remove duplicated files from all evaluation results and store
    the file path and format information in a data frame.
    \item Return the package metadata and the data frame in a list.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
system.file("examples/pkg1/", package = "pkglite") \%>\%
  collate(file_default())
}
