% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps_placeTypes.R
\name{get_places}
\alias{get_places}
\title{Label each cluster's place type using Google Places API}
\usage{
get_places(df, key = NULL, radius = 50)
}
\arguments{
\item{df}{A dataframe of GPS coordinates as described below}

\item{key}{A character vector with a Google API key. The default is NULL and must be set by the user.}

\item{radius}{The maximum radius the Google API should search within for nearby locations. The default is 50m.}
}
\value{
A dataframe with clusters labelled with specific place types (defined by Google) and general categories (defined by package creator)
}
\description{
Use get_places() to return the closest place type identified by Google Places API.
}
\section{Dataframe Requirements}{

The dataframe needs to have the following named columns:
\itemize{
  \item lat.centroid.final = latitude coordinates
  \item lon.centroid.final = longitude coordinates
}
}

\examples{
## Assume you have run get_clusters() and get_home() on the dataset "places_gps"
\dontrun{

## Please add your API key from Google - please be aware that this service may cost money.

key <- SET_KEY

labelled <- get_places(home[[2]], key)
}
}
\seealso{
\code{\link{get_clusters}} to cluster GPS coordinates into places.

\code{\link{get_home}} to predict which cluster is an individual's home
}
