% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symptomatic_area.R
\name{symptomatic_area}
\alias{symptomatic_area}
\title{Calculates the percentage of symptomatic area}
\usage{
symptomatic_area(
  img,
  img_healthy,
  img_symptoms,
  img_background = NULL,
  img_pattern = NULL,
  resize = FALSE,
  parallel = FALSE,
  workers = NULL,
  randomize = TRUE,
  nrows = 10000,
  show_image = FALSE,
  show_original = TRUE,
  show_background = TRUE,
  col_leaf = "green",
  col_symptoms = "red",
  col_background = NULL,
  save_image = FALSE,
  prefix = "proc_",
  dir_original = NULL,
  dir_processed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{img_healthy}{A color palette of healthy areas.}

\item{img_symptoms}{A color palette of symptomatic areas.}

\item{img_background}{A color palette of areas with symptoms.}

\item{img_pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{img_pattern = "im"} all images that the name
matches the pattern (e.g., img1.-, image1.-, im2.-) will be analyzed.
Providing any number as pattern (e.g., \code{img_pattern = "1"}) will select
images that are named as 1.-, 2.-, and so on.}

\item{resize}{Resize the image before processing? Defaults to \code{FALSE}. Use a
numeric value of range 0-100 (proportion of the size of the original
image).}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time, especially when \code{img_pattern} is used is informed. The
number of sections is set up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{randomize}{Randomize the lines before training the model?}

\item{nrows}{The number of lines to be used in training step.}

\item{show_image}{Show image after processing?}

\item{show_original}{Show the symptoms in the original image?}

\item{show_background}{Show the background? Defaults to \code{TRUE}. A white
background is shown by default when \code{show_original = FALSE}.}

\item{col_leaf}{Leaf color after image processing. Defaults to \code{"green"}}

\item{col_symptoms}{Symptoms color after image processing. Defaults to \code{"red"}.}

\item{col_background}{Background color after image processing. Defaults to
\code{"NULL"}.}

\item{save_image}{Save the image after processing? The image is saved in the
current working directory named with the prefix provided in \verb{proc_*} where
\code{*} is the image name given in \code{img}.}

\item{prefix}{The prefix to be included in the processed images. Defaults to
\code{"proc_"}.}

\item{dir_original, dir_processed}{The directory containing the original and
processed images. Defaults to \code{NULL}. In this case, the function will
search for the image \code{img} in the current working directory. After
processing, when \code{save_image = TRUE}, the processed image will be also
saved in such a directory.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A data frame with the results (healthy and symptomatic area) for each
image.
}
\description{
Calculates the percentage of symptomatic leaf area in sample or entire
leaf based on provided color palettes samples. A general linear model
(binomial family) fitted to the RGB values is used to segment the lesions from
the healthy leaf. If a pallet of background is provided, the function takes
care of the details to isolate it before computing the number and area of
lesions. By using \code{img_pattern} it is possible to process several images with
common pattern names that are stored in the current working directory or in
the subdirectory informed in \code{dir_original}.
}
\examples{
\donttest{
library(pliman)
img <- image_import(image_pliman("sev_leaf.jpg"))
healthy <- image_import(image_pliman("sev_healthy.jpg"))
symptoms <- image_import(image_pliman("sev_sympt.jpg"))
background <- image_import(image_pliman("sev_back.jpg"))
image_combine(img, healthy, symptoms,background)
symptomatic_area(img = img,
                 img_healthy = healthy,
                 img_symptoms = symptoms,
                 img_background = background,
                 show_image = TRUE)
}


}
