% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{utils_image}
\alias{utils_image}
\alias{image_import}
\alias{image_export}
\alias{image_show}
\alias{image_pliman}
\title{Import, display and export images}
\usage{
image_import(image, ..., img_pattern = NULL)

image_export(image, name, ...)

image_show(image)

image_pliman(image)
}
\arguments{
\item{image}{\itemize{
\item For \code{image_import()}, a character vector of file names or URLs.
\item For \code{image_export()}, an Image object, an array or a list of images.
}}

\item{...}{Alternative arguments passed to the corresponding functions from
the \code{jpeg}, \code{png}, and \code{tiff} packages.}

\item{img_pattern}{A pattern of file name used to identify images to be
imported. For example, if \code{img_pattern = "im"} all images in the current
working directory that the name matches the pattern (e.g., img1.-,
image1.-, im2.-) will be imported as a list. Providing any number as
pattern (e.g., \code{img_pattern = "1"}) will select images that are named as
1.-, 2.-, and so on.}

\item{name}{An string specifying the name of the image.}
}
\value{
\itemize{
\item \code{image_import()} returns a new \code{Image} object.
\item \code{image_export()} returns an invisible vector of file names.
\item \code{image_pliman()} returns a character string with the path to the example
image installed with the package.
}
}
\description{
Import images from files and URLs, write images to files, and show images.
*
}
\examples{
library(pliman)
img <- image_import(image_pliman("sev_leaf.jpg"))
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
