% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mask.R
\name{make_mask}
\alias{make_mask}
\title{Makes a mask in an image}
\usage{
make_mask(img, brush, rel_pos_x = 0.5, rel_pos_y = 0.5, plot = TRUE)
}
\arguments{
\item{img}{A \code{Image} object}

\item{brush}{An object created with \code{make_brush()}}

\item{rel_pos_x, rel_pos_y}{A relative position to include the brush in the
image. Defaults to 0.5. This means that the brush will be centered in the
original image. Smaller values move the brush toward the left and top,
respectively.}

\item{plot}{Plots the generated mask? Defaults to \code{TRUE}.}
}
\value{
A binary image with 0s and 1s.
}
\description{
Make a mask using an \code{Image} object and a brush.
}
\details{
It applies a brush to an Image, selecting the \code{Image} pixels that match the
brush values equal to 1. The position of the brush in the original image is
controlled by the relative positions x (\code{rel_pos_x}) and y (\code{rel_pos_y})
arguments.  The size of the brush must be smaller or equal to the smaller
dimension of \code{image}.
}
\examples{
img <- image_pliman("soybean_touch.jpg")
make_mask(img, brush = make_brush(size = 201))
make_mask(img,
          brush = make_brush(size = 401, shape = "diamond"),
          rel_pos_x = 0.1,
          rel_pos_y = 0.8)
}
