% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_serial.R
\name{pwartest}
\alias{pwartest}
\alias{pwartest.formula}
\alias{pwartest.panelmodel}
\title{Wooldridge Test for AR(1) Errors in FE Panel Models}
\usage{
pwartest(x, ...)

\method{pwartest}{formula}(x, data, ...)

\method{pwartest}{panelmodel}(x, ...)
}
\arguments{
\item{x}{an object of class \code{formula} or of class \code{panelmodel},}

\item{\dots}{further arguments to be passed on to \code{vcovHC} (see
Details and Examples).}

\item{data}{a \code{data.frame},}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of serial correlation for (the idiosyncratic component of) the errors
in fixed--effects panel models.
}
\details{
As \insertCite{WOOL:10;textual}{plm}, Sec. 10.5.4 observes, under
the null of no serial correlation in the errors, the residuals of a
FE model must be negatively serially correlated, with
\eqn{cor(\hat{u}_{it}, \hat{u}_{is})=-1/(T-1)} for each
\eqn{t,s}. He suggests basing a test for this null hypothesis on a
pooled regression of FE residuals on their first lag:
\eqn{\hat{u}_{i,t} = \alpha + \delta \hat{u}_{i,t-1} +
\eta_{i,t}}. Rejecting the restriction \eqn{\delta = -1/(T-1)}
makes us conclude against the original null of no serial
correlation.

\code{pwartest} estimates the \code{within} model and retrieves residuals,
then estimates an AR(1) \code{pooling} model on them. The test statistic
is obtained by applying a F test to the latter model to test the
above restriction on \eqn{\delta}, setting the covariance matrix to
\code{vcovHC} with the option \code{method="arellano"} to control for serial
correlation.

Unlike the \code{\link[=pbgtest]{pbgtest()}} and \code{\link[=pdwtest]{pdwtest()}}, this test does
not rely on large--T asymptotics and has therefore good properties in
``short'' panels.  Furthermore, it is robust to general heteroskedasticity.
}
\examples{

data("EmplUK", package = "plm")
pwartest(log(emp) ~ log(wage) + log(capital), data = EmplUK)

# pass argument 'type' to vcovHC used in test
pwartest(log(emp) ~ log(wage) + log(capital), data = EmplUK, type = "HC3")


}
\references{
\insertRef{WOOL:02}{plm}

\insertRef{WOOL:10}{plm}
}
\seealso{
\code{\link[=pwfdtest]{pwfdtest()}}, \code{\link[=pdwtest]{pdwtest()}}, \code{\link[=pbgtest]{pbgtest()}}, \code{\link[=pbltest]{pbltest()}},
\code{\link[=pbsytest]{pbsytest()}}.
}
\author{
Giovanni Millo
}
\keyword{htest}
