% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field3logit.R
\name{field3logit}
\alias{field3logit}
\alias{print.field3logit}
\alias{plot.field3logit}
\alias{as_tibble.field3logit}
\alias{as.data.frame.field3logit}
\alias{fortify.field3logit}
\alias{coef.field3logit}
\alias{vcov.field3logit}
\title{Computation of the vector field}
\usage{
field3logit(
  model,
  delta,
  label = "<empty>",
  p0 = NULL,
  alpha = NULL,
  vcov = NULL,
  ncurves = 8,
  narrows = Inf,
  edge = 0.01,
  conf = NA,
  npoints = 100
)

\method{print}{field3logit}(x, ...)

\method{plot}{field3logit}(x, ..., add = FALSE, length = 0.05)

\method{as_tibble}{field3logit}(x, ..., wide = TRUE)

\method{as.data.frame}{field3logit}(x, ..., wide = TRUE)

\method{fortify}{field3logit}(model, data, ...)

\method{coef}{field3logit}(object, ...)

\method{vcov}{field3logit}(object, ...)
}
\arguments{
\item{model}{either a fitted trinomial model or a matrix of regressor
coefficients. See section \emph{Compatibility} and examples of
\code{\link{plot3logit-package}}.}

\item{delta}{the change in the values of covariates to be represented.
This could be either a \code{numeric} vector, the name of a covariate
(passed either as a \code{character} or an \code{expression}), or a mathematical
expression involving one or more than one covariates (passed either as
a \code{character} or an \code{expression}). See details and examples.}

\item{label}{label to be used for identifying the field when multiple
fields are plotted. See \code{\link[=multifield3logit]{multifield3logit()}}.}

\item{p0}{\code{list} of starting points (ternary coordinates) of the curves
of the field. If not specified, \code{field3logit} automatically compute
\code{ncurves} candidate points so that arrows are evenly distributed over
the ternary plot area. See Examples.}

\item{alpha}{\code{numeric} vector of length two where constants \eqn{\alpha^{(1)}}
and \eqn{\alpha^{(2)}} are stored (only for ordinal models), as
defined in Equation (7) of \insertCite{santi2019;textual}{plot3logit}.}

\item{vcov}{(\strong{only if} the model is read from a matrix, otherwise it will
be ignored) variance-covariance matrix of parameter estimates. The elements
of the variance-covariance matrix should be ordered according to the matrix
of parameter estimates where the categories of the dependent variable are
the slow index, whereas the covariates are the fast index.}

\item{ncurves}{number of curves of the field to be computed. In case
of ordinal models, this parameter is ineffective, as only one curve
can be drawn. The parameter is ineffective also in case that argument
\code{p0} is set.}

\item{narrows}{maximum number of arrows to be drawn per curve.}

\item{edge}{minimum distance between each arrow (or point) and
the edge of the ternary plot.}

\item{conf}{confidence level of confidence regions to be computed \strong{for each
arrow} of the field.}

\item{npoints}{number of points of the border to be computed \strong{for each
confidence region}.}

\item{x, object}{object of class \code{field3logit}.}

\item{...}{other arguments passed to or from other methods.}

\item{add}{\code{logical} argument which specifies whether the field
should be added to an existing plot (\code{add = TRUE}) or a new
ternary plot should be drawn (\code{add = FALSE}).}

\item{length}{length of the edges of the arrow head (in inches).}

\item{wide}{it allows to choose whether \code{as.data.frme} should return a
\code{data.frame} object in wide (default) or long form.}

\item{data}{not used. Argument included only for interface compatibility with
the generic \code{fortify}.}
}
\value{
\code{S3} object of class \code{field3logit} structured as a named \code{list}.
}
\description{
\code{\link[=field3logit]{field3logit()}} computes the vector field associated to a change in
regressior values (which may involve more than one regressor) of a trinomial
logit model either fitted by some multinomial regression function or
explicitly specified.

The method \code{\link[=plot]{plot()}} draws the ternary plot using standard graphics methods
provided by package \code{Ternary}. See function \code{\link[=gg3logit]{gg3logit()}} for plotting
through the package \code{\link[ggtern:ggtern-package]{ggtern}} based on the grammar
of graphics.
}
\details{
Argument \code{delta} could be passed in one of the following formats:
\itemize{
\item explicitly, as a \code{numeric} vector corresponding to the change
\eqn{\Delta x\in\bm{R}^k} in regressors values \eqn{x\in\bm{R}^k};
\item implicitly, as a \code{character} of the name of the covariate to be considered.
In this case, vector \eqn{\Delta x\in\bm{R}^k} is computed for a unit
change of the specified covariate;
\item as a mathematical expression (passed as an \code{expression} or a \code{character}
object) involving one or more than one covariates. This allows one to
analyse the effects of composite covariate changes through an easy-to-write
and easy-to-read code without having to cope with explicit numerical
specification of vector \eqn{\Delta x\in\bm{R}^k}.
}

See examples for comparing all three methods.
}
\examples{
\dontrun{
data(cross_1year)

# Model fit
mod0 <- nnet::multinom(employment_sit ~ finalgrade + irregularity + hsscore,
  cross_1year)
mod0

# Assessing the effect of "finalgradeHigh" (explicit notation)
field0 <- field3logit(mod0, c(0, 0, 1, 0, 0, 0))
gg3logit(field0) + stat_field3logit()

# Assessing the effect of "finalgradeHigh" (implicit notation)
field0 <- field3logit(mod0, 'finalgradeHigh')
gg3logit(field0) + stat_field3logit()

# Assessing the combined effect of "finalgradeHigh" and
# a decrease of "hsscore" by 10
field0 <- field3logit(mod0, 'finalgradeHigh - 10 * hsscore')
gg3logit(field0) + stat_field3logit()
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=multifield3logit]{multifield3logit()}}, \code{\link[=gg3logit]{gg3logit()}}, \code{\link[=autoplot]{autoplot()}}.
}
