% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_roc.R
\docType{data}
\name{GeomRoc}
\alias{GeomRoc}
\alias{geom_roc}
\title{Empirical Receiver Operating Characteristic Curve}
\format{
An object of class \code{GeomRoc} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.
}
\usage{
GeomRoc

geom_roc(
  mapping = NULL,
  data = NULL,
  stat = "roc",
  n.cuts = 10,
  arrow = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  linealpha = 1,
  pointalpha = 1,
  pointsize = 0.5,
  labels = TRUE,
  labelsize = 3.88,
  labelround = 1,
  na.rm = TRUE,
  cutoffs.at = NULL,
  cutoff.labels = NULL,
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_roc} and \code{stat_roc}.}

\item{n.cuts}{Number of cutpoints to display along each curve}

\item{arrow}{Arrow specification, as created by \code{\link[grid]{arrow}}}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{linealpha}{Alpha level for the lines, alpha.line is deprecated}

\item{pointalpha}{Alpha level for the cutoff points, alpha.point is deprecated}

\item{pointsize}{Size of cutoff points, size.point is deprecated}

\item{labels}{Logical, display cutoff text labels}

\item{labelsize}{Size of cutoff text labels}

\item{labelround}{Integer, number of significant digits to round cutoff labels}

\item{na.rm}{Remove missing values from curve}

\item{cutoffs.at}{Vector of user supplied cutoffs to plot as points. If non-NULL, 
it will override the values of n.cuts and plot the observed cutoffs closest to the user-supplied ones.}

\item{cutoff.labels}{vector of user-supplied labels for the cutoffs.  Must be a character vector of
the same length as cutoffs.at.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Display the empirical ROC curve. Useful for characterizing the classification
accuracy of continuous measurements for predicting binary states
}
\section{Computed variables}{

\describe{
  \item{false_positive_fraction}{estimate of false positive fraction}
  \item{true_positive_fraction}{estimate of true positive fraction}
  \item{cutoffs}{values of m at which estimates are calculated}
}
}

\section{Aesthetics}{

\code{geom_roc} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}} The FPF estimate. This is automatically mapped by \link{stat_roc}
  \item \strong{\code{y}} The TPF estimate. This is automatically mapped by \link{stat_roc}
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{
D.ex <- rbinom(50, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(50, mean = D.ex, sd = .4), rnorm(50, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 50), rep("B", 50)))

ggplot(rocdata, aes(m = M, d = D)) + geom_roc()
\donttest{
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc()
ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + facet_wrap(~ Z)
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(n.cuts = 20)
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(cutoffs.at = c(1.5, 1, .5, 0, -.5))
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(labels = FALSE)
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(size = 1.25)
}
}
\seealso{
See \code{\link{geom_rocci}} for
  displaying rectangular confidence regions for the empirical ROC curve, \code{\link{style_roc}} for 
  adding guidelines and labels, and \code{\link{direct_label}} for adding direct labels to the 
  curves. Also \link{export_interactive_roc} for creating interactive ROC curve plots for use in a web browser.
}
\keyword{datasets}
