\name{predict.plus}
\alias{predict.plus}
\alias{coef.plus}
\title{Extract coefficients and make predictions from a plus solution path. }
\description{
While plus() produces turning points in a path of critical points of a penalized squared loss, 
predict.plus extracts coefficients and make predictions at particular penalty levels by linear 
interpolation. The extracted coefficients are the same as these produced by plus() when the 
input lam is the same. 
}
\usage{
\method{predict}{plus}(object, lam, newx, ...) 
\method{coef}{plus}(object, lam, ...) 
}
\arguments{
  \item{object}{A fitted plus object}
  \item{lam}{A decreasing sequence of nonnegative numbers as penalty levels at which the 
	coefficients are extracted and predictions are required. Default is the ordered values 
	of lam.path generated by plus(). 
}
  \item{newx}{x values at which the fit is required. If newx is not set, coefficients are extacted 
	but predictions are not produced.}
  \item{\dots}{Additonal arguments for generic methods}  	
}
\value{
A list containing the following items: 
\item{lambda}{penalty levels at which the coefficients and predicted values are extracted.}
\item{coefficients}{extracted coefficients.}
\item{dimension}{number of nonzero coefficients.}
\item{r.square}{R-square as the ratio of the total centered residual sum of squares and the 
	total centered sum of squares. }
\item{step}{number of plus steps required to compute the coefficients.}
\item{method}{including the LASSO, MC+, and SCAD.}
\item{newy}{extracted predictions at newx; not produced if newx is not supplied.}  
\item{\dots}{Additonal arguments for generic methods}
}
\references{
Zhang, C.-H. (2007). Penalized linear unbiased selection. Technical Report No. 2007-003. 
Department of Statistics, Rutgers University.
}
\seealso{print, plot, plus}
\author{Cun-Hui Zhang and Ofer Melnik}
\examples{
data(sp500)
attach(sp500)

x <- sp500.percent[,3: (dim(sp500.percent)[2])] 
y <- sp500.percent[,1]

object <- plus(x,y,method="mc+")
## extract coefficients for the first 10 values of lam.path at values in x  
extracted.values <- predict(object, lam = sort(object$lam.path[1:10],decreasing=TRUE), newx=object$x)
extracted.coef <- coef(object, lam = sort(object$lam.path[1:10],decreasing=TRUE))
detach(sp500)
}
\keyword{methods}
