% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petrinet.R
\name{petrinet_check_wfnet}
\alias{petrinet_check_wfnet}
\title{Check Workflow net property}
\usage{
petrinet_check_wfnet(pn, convert = TRUE)
}
\arguments{
\item{pn}{Petri net}

\item{convert}{\code{TRUE} to automatically convert Python objects to their R equivalent. If you pass \code{FALSE} you can do manual conversion using the \link[reticulate]{r-py-conversion} function.}
}
\value{
A single logical
}
\description{
Checks if the Petri net is a Workflow net
}
\examples{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4PY is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  net <- discovery_inductive(patients_completes)
  petrinet_check_wfnet(net$petrinet)

}
}
