% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary.R
\name{summary.moleculeFilt}
\alias{summary.moleculeFilt}
\title{Molecule Filter Summary}
\usage{
\method{summary}{moleculeFilt}(object, min_num = NULL, ...)
}
\arguments{
\item{object}{S3 object of class 'moleculeFilt' created by
\code{\link{molecule_filter}}}

\item{min_num}{integer value specifying the minimum number of times each
feature must be observed across all samples. Default value is NULL.}

\item{...}{further arguments passed to or from other methods}
}
\value{
a summary table giving the number of biomolecules by number of
  observed values across all samples. If min_num is specified, the numbers of
  biomolecules to be filtered and to be retained based on the specified
  threshold are reported. If, upon creation of moleculeFilt object,
  \code{use_groups = TRUE} or \code{use_batches = TRUE} were specified, the
  numbers reported by the summary are based on groups and/or batches.
}
\description{
Provide summary of a moleculeFilt S3 object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myfilter <- molecule_filter(omicsData = pep_object)
summary(myfilter)
summary(myfilter, min_num = 2)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{molecule_filter}}
}
\author{
Lisa Bramer, Kelly Stratton
}
