% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots_seqData.R
\name{trelli_rnaseq_histogram}
\alias{trelli_rnaseq_histogram}
\title{Histogram trelliscope building function for RNA-Seq data}
\usage{
trelli_rnaseq_histogram(
  trelliData,
  cognostics = c("sample count", "mean lcpm", "median lcpm", "cv lcpm", "skew lcpm"),
  ggplot_params = NULL,
  interactive = FALSE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object made by as.trelliData or
as.trelliData.edata, and grouped by edata_cname in trelli_panel_by.
Must be built using seqData. Required.}

\item{cognostics}{A vector of cognostic options for each plot. Valid entries
are "sample count", "mean lcpm", "median lcpm", "cv lcpm", 
and "skew lcpm". All are included by default.}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "ylim(c(1,2))").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope.}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of histograms that is stored in `path`
}
\description{
Specify a plot design and cognostics for the abundance histogram
  trelliscope. Main_effects grouping are ignored. Data must be grouped by
  edata_cname. For MS/NMR data, use "trelli_abundance_histogram".
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(pmartRdata)

trelliData_seq1 <- as.trelliData.edata(e_data = rnaseq_edata, 
                                      edata_cname = "Transcript",
                                      omics_type = "seqData")
omicsData_seq <- group_designation(omicsData = rnaseq_object, main_effects = c("Virus"))

# Filter low transcript counts
omicsData_seq <- applyFilt(filter_object = total_count_filter(omicsData = omicsData_seq), 
 omicsData = omicsData_seq, min_count = 15)

# Select a normalization and statistics method (options are 'edgeR', 'DESeq2', and 'voom').
# See ?difexp_seq for more details
statRes_seq <- diffexp_seq(omicsData = omicsData_seq, method = "voom")

# Generate the trelliData object
trelliData_seq2 <- as.trelliData(omicsData = omicsData_seq)
trelliData_seq3 <- as.trelliData(statRes = statRes_seq)
trelliData_seq4 <- as.trelliData(omicsData = omicsData_seq, statRes = statRes_seq)

# Build the RNA-seq histogram with an edata file. 
# Generate trelliData in as.trelliData.edata
trelli_panel_by(trelliData = trelliData_seq1, panel = "Transcript") \%>\% 
   trelli_rnaseq_histogram(test_mode = TRUE, test_example = 1:10, path = tempdir())

# Build the RNA-seq histogram with an omicsData object. 
# Generate trelliData in as.trelliData
trelli_panel_by(trelliData = trelliData_seq2, panel = "Transcript") \%>\% 
   trelli_rnaseq_histogram(test_mode = TRUE, test_example = 1:10, path = tempdir())
    
# Build the RNA-seq histogram with an omicsData and statRes object. 
# Generate trelliData in as.trelliData.
trelli_panel_by(trelliData = trelliData_seq4, panel = "Transcript") \%>\%
   trelli_rnaseq_histogram(test_mode = TRUE, test_example = 1:10, 
     cognostics = "sample count", path = tempdir())
   
# Users can modify the plotting function with ggplot parameters and interactivity, 
# and can also select certain cognostics.     
trelli_panel_by(trelliData = trelliData_seq1, panel = "Transcript") \%>\% 
   trelli_rnaseq_histogram(test_mode = TRUE, test_example = 1:10, 
     ggplot_params = c("ylab('')", "xlab('')"), interactive = TRUE,
     cognostics = c("mean lcpm", "median lcpm"), path = tempdir())  

\dontshow{closeAllConnections()}
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
