% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getpmd}
\alias{getpmd}
\title{Get pmd for specific reaction}
\usage{
getpmd(list, pmd, rtcutoff = 10, corcutoff = NULL, digits = 2, accuracy = 4)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{pmd}{a specific paired mass distances}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}
}
\value{
list with paired peaks for specific pmd.
}
\description{
Get pmd for specific reaction
}
\examples{
data(spmeinvivo)
pmd <- getpmd(spmeinvivo,pmd=15.99)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{getrda}}
}
