% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibble.R
\name{pibble}
\alias{pibble}
\title{Create a pibble panel data set object}
\usage{
pibble(..., .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE)
}
\arguments{
\item{...}{A set of name-value pairs to make up the variables of a \code{pibble}.}

\item{.i}{Quoted or unquoted variable(s) that identify the individual cases. If this is omitted, \code{pibble} will assume the data set is a single time series.}

\item{.t}{Quoted or unquoted variable indicating the time. \code{pmdplyr} accepts two kinds of time variables: numeric variables where a fixed distance \code{.d} will take you from one observation to the next, or, if \code{.d=0}, any standard variable type with an order. Consider using the \code{time_variable()} function to create the necessary variable if your data uses a \code{Date} variable for time.}

\item{.d}{Number indicating the gap in \code{t} between one period and the next. For example, if \code{.t} indicates a single day but data is collected once a week, you might set \code{.d=7}. To ignore gap length and assume that "one period ago" is always the most recent prior observation in the data, set \code{.d=0}. By default, \code{.d=1}.}

\item{.uniqcheck}{Logical parameter. Set to TRUE to perform a check of whether \code{.i} and \code{.t} uniquely identify observations, and present a message if not. By default this is set to FALSE and the warning message occurs only once per session.}
}
\description{
This function declares a pibble tibble with the attributes \code{.i}, \code{.t}, and \code{.d}.
}
\details{
\itemize{
  \item \code{.i}, Quoted or unquoted variable(s) indicating the individual-level panel identifier
  \item \code{.t}, Quoted or unquoted variable indicating the time variable
  \item \code{.d}, a number indicating the gap
}

The \code{pibble()} function is for the purpose of creating \code{pibble} objects from scratch. You probably want \code{as_pibble}.

Note that \code{pibble} does not require that \code{.i} and \code{.t} uniquely identify the observations in your data, but it will give a warning message (a maximum of once per session, unless \code{.uniqcheck=TRUE}) if they do not.
}
\examples{
# Creating a pibble from scratch
pd <- pibble(
  i = c(1, 1, 1, 2, 2, 2),
  t = c(1, 2, 3, 1, 2, 2),
  x = rnorm(6),
  .i = i,
  .t = t
)
is_pibble(pd)
# I set .d=0 here to indicate that I don't care how large the gap between one period and the next is
# If I want to use 'seconds' for t.
# See time_variable() to turn unruly variables into well-behaved integers, as well
pd2 <- pibble(
  i = c(1, 1, 1, 2, 2, 2),
  seconds = c(123, 456, 789, 103, 234, 238),
  .i = i,
  .t = seconds,
  .d = 0
)
is_pibble(pd2)
}
