% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialCorrelation.R
\name{SpatialCorrelation}
\alias{SpatialCorrelation}
\title{R6 class representing a spatial correlation.}
\description{
\code{\link[R6:R6Class]{R6}} class functionality for modeling spatial correlations
within a spatially-explicit model. It provides functionality for calculating
correlations between region cells using a distance-based function:
\emph{a*exp(-distance/b)}, where \emph{a} (amplitude) and \emph{b} (breadth) are
configurable model attributes. It then calculates the Cholesky decomposition of
the correlation matrix (via \code{\link[base:chol]{chol}}), which is utilized to
generate (optionally temporal) correlated normal deviates. A compacted version of
the decomposed matrix can also generated for computational efficiency.
}
\examples{
# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
# Spatial correlation
env_corr <- SpatialCorrelation$new(region = region, amplitude = 0.4, breadth = 500)
env_corr$calculate_distance_matrix() # m
env_corr$calculate_correlations(decimals = 5)
env_corr$correlation_matrix
env_corr$calculate_cholesky_decomposition(decimals = 2)
env_corr$t_decomposition_matrix
env_corr$get_compact_decomposition()
# Scale to km
env_corr$distance_scale <- 1000
env_corr$calculate_distance_matrix() # km

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{SpatialCorrelation}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{distance_scale}}{Scale of distance values in meters (default = 1). Usage: set to 1 for values in meters, or to 1000 for values in kilometers.}

\item{\code{correlation_amplitude}}{Correlation function: \emph{a*exp(-distance/b)} \emph{a} parameter. Represents the amplitude or maximum magnitude of correlation values between model cells.}

\item{\code{correlation_breadth}}{Correlation function: \emph{a*exp(-distance/b)} \emph{b} parameter. Represents the breadth of the correlation between region cells. Typically estimated via average distance between correlated region cells.}

\item{\code{correlation_matrix}}{Correlation matrix calculated via correlation function: \emph{a*exp(-distance/b)}.}

\item{\code{t_decomposition_matrix}}{The transposed Cholesky decomposition of the correlation matrix (see \code{\link[base:chol]{chol}}).}

\item{\code{compact_only}}{Boolean to indicate that only the compact versions of matrices will be maintained once calculated.}

\item{\code{t_decomposition_compact_matrix}}{A compact (rows) version of the transposed Cholesky decomposition of the correlation matrix.}

\item{\code{t_decomposition_compact_map}}{A map of the original region cell rows for the compact transposed decomposition matrix.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpatialCorrelation-new}{\code{SpatialCorrelation$new()}}
\item \href{#method-SpatialCorrelation-calculate_distance_matrix}{\code{SpatialCorrelation$calculate_distance_matrix()}}
\item \href{#method-SpatialCorrelation-calculate_correlations}{\code{SpatialCorrelation$calculate_correlations()}}
\item \href{#method-SpatialCorrelation-calculate_cholesky_decomposition}{\code{SpatialCorrelation$calculate_cholesky_decomposition()}}
\item \href{#method-SpatialCorrelation-calculate_compact_decomposition}{\code{SpatialCorrelation$calculate_compact_decomposition()}}
\item \href{#method-SpatialCorrelation-get_compact_decomposition}{\code{SpatialCorrelation$get_compact_decomposition()}}
\item \href{#method-SpatialCorrelation-generate_correlated_normal_deviates}{\code{SpatialCorrelation$generate_correlated_normal_deviates()}}
\item \href{#method-SpatialCorrelation-clone}{\code{SpatialCorrelation$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_names"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_names'><code>poems::GenericModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attributes'><code>poems::GenericModel$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="set_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-set_attributes'><code>poems::GenericModel$set_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SpatialModel" data-id="new_clone"><a href='../../poems/html/SpatialModel.html#method-SpatialModel-new_clone'><code>poems::SpatialModel$new_clone()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets given attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$new(compact_only = TRUE, attribute_aliases = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compact_only}}{Boolean to indicate that only the compact versions of matrices will be maintained once calculated.}

\item{\code{attribute_aliases}}{Optional list of extra alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-calculate_distance_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-calculate_distance_matrix}{}}}
\subsection{Method \code{calculate_distance_matrix()}}{
Returns a matrix with the calculated distance (in meters by default) between each pair of region cells.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$calculate_distance_matrix(use_longlat = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_longlat}}{Optional boolean indicating use of (WGS84) coordinates in longitude (degrees West) and latitude (degrees North).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix with distances between region cells.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-calculate_correlations"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-calculate_correlations}{}}}
\subsection{Method \code{calculate_correlations()}}{
Calculates the correlation matrix by applying the distance-based correlation function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$calculate_correlations(
  distance_matrix = NULL,
  decimals = NULL,
  threshold = 1e-07,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distance_matrix}}{Optional pre-calculated matrix with distances between region cells.}

\item{\code{decimals}}{Optional number of decimal places for correlation values.}

\item{\code{threshold}}{Optional threshold (minimum value) for correlation values (default 0.0000001).}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-calculate_cholesky_decomposition"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-calculate_cholesky_decomposition}{}}}
\subsection{Method \code{calculate_cholesky_decomposition()}}{
Calculates the transposed Cholesky decomposition of the correlation matrix (via \code{\link[base:chol]{chol}}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$calculate_cholesky_decomposition(
  distance_matrix = NULL,
  decimals = NULL,
  threshold = 1e-07,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distance_matrix}}{Optional pre-calculated matrix with distances between region cells.}

\item{\code{decimals}}{Optional number of decimal places for correlation values.}

\item{\code{threshold}}{Optional threshold (minimum value) for correlation values (default 0.0000001).}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-calculate_compact_decomposition"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-calculate_compact_decomposition}{}}}
\subsection{Method \code{calculate_compact_decomposition()}}{
Compacts the transposed Cholesky decomposition of the correlation matrix into the minimal number of rows, which are mapped to the original matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$calculate_compact_decomposition(distance_matrix = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distance_matrix}}{Optional pre-calculated matrix with distances between region cells.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-get_compact_decomposition"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-get_compact_decomposition}{}}}
\subsection{Method \code{get_compact_decomposition()}}{
Returns a compact transposed Cholesky decomposition of the correlation matrix and a corresponding map of region cell indices in a list with names: matrix, map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$get_compact_decomposition(distance_matrix = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distance_matrix}}{Optional pre-calculated matrix with distances between region cells.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List containing a compact Cholesky decomposition matrix and a corresponding map of region cell indices (for the compacted rows).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-generate_correlated_normal_deviates"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-generate_correlated_normal_deviates}{}}}
\subsection{Method \code{generate_correlated_normal_deviates()}}{
Generates correlated normal deviates using the spatial correlation, utilizing the optional random seed and optional temporal correlation across time steps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$generate_correlated_normal_deviates(
  random_seed = NULL,
  temporal_correlation = 1,
  time_steps = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{random_seed}}{Optional seed for the random generation of correlated deviates.}

\item{\code{temporal_correlation}}{Optional temporal correlation coefficient (0-1; default = 1).}

\item{\code{time_steps}}{Optional number of time steps for temporal correlation (default = 1 or none).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Array (non-temporal) or matrix (temporal) of correlated normal deviates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpatialCorrelation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpatialCorrelation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpatialCorrelation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
