% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{factors.single}
\alias{factors.single}
\title{Get latent factors for a new user given her item counts}
\usage{
factors.single(
  model,
  X,
  l2_reg = model$l2_reg,
  l1_reg = model$l1_reg,
  weight_mult = model$weight_mult,
  maxupd = model$maxupd
)
}
\arguments{
\item{model}{Poisson factorization model as returned by `poismf`.}

\item{X}{Data with the non-zero item indices and counts for this new user. Can be
passed as a sparse vector from package `Matrix` (`Matrix::dsparseVector`, which can
be created from indices and values through function `Matrix::sparseVector`), or
as a `data.frame`, in which case will take the first column as the item/column indices
(numeration starting at 1) and the second column as the counts. If `X` passed to
`poismf` was a `data.frame`, `X` here must also be a `data.frame`.}

\item{l2_reg}{Strength of L2 regularization to use for optimizing the new factors.}

\item{l1_reg}{Strength of the L1 regularization. Not recommended.}

\item{weight_mult}{Weight multiplier for the positive entries over the missing entries.}

\item{maxupd}{Maximum number of Newton-CG updates to perform. You might want to
increase this value depending on the use-case.}
}
\value{
Vector of dimensionality `model$k` with the latent factors for the user,
given the input data.
}
\description{
This is similar to obtaining topics for a document in LDA. See also
function \link{factors} for getting factors for multiple users/rows at
a time.

This function works with one user at a time, and will use the
truncated Newton-CG approach regardless of how the model was fit.
Note that, since this optimization method will likely have
different optimal hyperparameters than the other methods, it
offers the option of varying those hyperparameters in here.
}
\details{
The factors are initialized to the mean of each column in the fitted model.
}
\seealso{
\link{factors} \link{topN.new}
}
