% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{plot.policy_data}
\alias{plot.policy_data}
\title{Plot policy data for given policies}
\usage{
\method{plot}{policy_data}(
  x,
  policy = NULL,
  which = c(1),
  stage = 1,
  history_variables = NULL,
  jitter = 0.05,
  ...
)
}
\arguments{
\item{x}{Object of class \link{policy_data}}

\item{policy}{An object or list of objects of class \link{policy}}

\item{which}{A subset of the numbers 1:2
\itemize{
\item{1} Spaghetti plot of the cumulative rewards
\item{2} Plot of the policy actions for a given stage
}}

\item{stage}{Stage number for plot 2}

\item{history_variables}{character vector of length 2 for plot 2}

\item{jitter}{numeric}

\item{...}{Additional arguments}
}
\description{
Plot policy data for given policies
}
\examples{
library("polle")
library("data.table")
setDTthreads(1)
d3 <- sim_multi_stage(2e2, seed = 1)
pd3 <- policy_data(data = d3$stage_data,
                   baseline_data = d3$baseline_data,
                   type = "long",
                   id = "id",
                   stage = "stage",
                   event = "event",
                   action = "A",
                   utility = "U")

# specifying two static policies:
p0 <- policy_def(c(1,1,0,0), name = "p0")
p1 <- policy_def(c(1,0,0,0), name = "p1")

plot(pd3)
plot(pd3, policy = list(p0, p1))

# learning and plotting a policy:
suppressWarnings({
 pe3 <- policy_eval(pd3,
                    policy_learn = policy_learn(),
                    q_models = q_glm(formula = ~t + X + X_lead))
plot(pd3, list(get_policy(pe3), p0))

# plotting the recommended actions at a specific stage:
plot(pd3, get_policy(pe3),
     which = 2,
     stage = 2,
     history_variables = c("t","X"))
})
}
