% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollstr.R
\name{pollster_api}
\alias{pollster_api}
\alias{pollster_polls}
\alias{pollster_polls_slug}
\alias{pollster_questions}
\alias{pollster_questions_slug}
\alias{pollster_questions_responses_clean}
\alias{pollster_questions_responses_raw}
\alias{pollster_charts}
\alias{pollster_charts_slug}
\alias{pollster_charts_polls}
\alias{pollster_charts_trendlines}
\alias{pollster_tags}
\title{Make Huffpost Poster API request}
\usage{
pollster_api(path, query = NULL, version = "v2", response_type = NULL,
  as = "parsed", ...)

pollster_polls(cursor = NULL, tags = NULL, question = NULL,
  sort = c("created_at", "updated_at"), ...)

pollster_polls_slug(slug, ...)

pollster_questions(cursor = NULL, tags = NULL, election_date = NULL, ...)

pollster_questions_slug(slug, ...)

pollster_questions_responses_clean(slug, ...)

pollster_questions_responses_raw(slug, ...)

pollster_charts(cursor = NULL, tags = NULL, election_date = NULL, ...)

pollster_charts_slug(slug, ...)

pollster_charts_polls(slug, ...)

pollster_charts_trendlines(slug, ...)

pollster_tags(...)
}
\arguments{
\item{path}{The API endpoint, as a character vector. If the length is greater than one, the elements will be collapsed and separated by \code{"/"}.}

\item{query}{Query parameters as a \code{list}.}

\item{version}{The API version.}

\item{response_type}{Response content type. One of \code{"json"}, \code{"tsv"}, or \code{"xml"}. Some endpoints are json/xml, and some are tsv.}

\item{as}{Passed to \code{\link[httr]{content}}.}

\item{...}{Arguments passed to \code{\link[httr]{GET}}.}

\item{cursor}{Special string used to handle pagination.}

\item{tags}{Character vector of tag names.}

\item{question}{Question slug.}

\item{sort}{Sort order of polls.}

\item{slug}{Unique identifier for the poll or question or chart.}

\item{election_date}{A date object or a string in "YYYY-MM-DD" format for the election date.}
}
\value{
A \code{pollster_api} object which is a list with elements
\itemize{
\item{\code{content}:}{The parsed content of the response},
\item{\code{url}:}{The URL of the request},
\item{\code{response}:}{The request object returned by \code{\link{GET}}.}
}
}
\description{
The function \code{pollster_api} is the lower-level function for making a request to the Huffpost Pollster API.
There is also a function for each methods provided by the API.
}
\section{Functions}{
\itemize{
\item \code{pollster_polls}: Get polls. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_polls}{API docs}.

\item \code{pollster_polls_slug}: Get a single poll. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_polls_slug}{API docs}.

\item \code{pollster_questions}: Get questions. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_questions}{API docs}.

\item \code{pollster_questions_slug}: Get a poll question. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_questions_slug}{API Docs}.

\item \code{pollster_questions_responses_clean}: Get a table where each row where each row is a single poll question + subpopulation and columns are response labels. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_questions_slug_poll_responses_clean_tsv}{API Docs}.

\item \code{pollster_questions_responses_raw}: Get a table where each row is single poll question + subpopulation + response. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_questions_slug_poll_responses_raw_tsv}{API Docs}.

\item \code{pollster_charts}: Return a list of charts. See href{https://app.swaggerhub.com/swagger-ui/#!/default/get_charts}{API Docs}.

\item \code{pollster_charts_slug}: Get a chart. See href{https://app.swaggerhub.com/swagger-ui/#!/default/get_charts_slug}{API Docs}.

\item \code{pollster_charts_polls}: Get table with one row per poll used in a chart. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_charts_slug_pollster_chart_poll_questions_tsv}{API Docs}.

\item \code{pollster_charts_trendlines}: Get table with the trendline estimates used in a chart. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_charts_slug_pollster_trendlines_tsv}{API Docs}.

\item \code{pollster_tags}: Return the list of tags used in polls, questions, and charts. See \href{https://app.swaggerhub.com/swagger-ui/#!/default/get_tags}{API Docs}.
}}

