% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size_method.R
\docType{methods}
\name{size}
\alias{size}
\alias{size,character-method}
\alias{size,partition-method}
\alias{size,DocumentTermMatrix-method}
\title{Get number of tokens.}
\usage{
size(x, ...)

\S4method{size}{character}(x, sAttribute = NULL, verbose = TRUE)

\S4method{size}{partition}(x, sAttribute = NULL)

\S4method{size}{DocumentTermMatrix}(x)
}
\arguments{
\item{x}{object to get size(s) for}

\item{...}{further arguments}

\item{sAttribute}{character vector with s-attributes (one or more)}

\item{verbose}{logical, whether to print messages}
}
\value{
an integer vector if sAttribute is NULL, a \code{data.table} otherweise
}
\description{
The method will get the number of tokens in a corpus or partition,
or the dispersion across one or more s-attributes.
}
\details{
One or more s-attributes can be provided to get the dispersion of
tokens across one or more dimensions. Two or more s-attributes
can lead to reasonable results only if the corpus XML is flat.
}
\examples{
\dontrun{
use("polmineR.sampleCorpus")
size("PLPRBTTXT")
size("PLPRBTTXT", sAttribute = "text_date")
size("PLPRBTTXT", sAttribute = c("text_date", "text_party"))

P <- partition("PLPRBTTXT", text_date = "2009-11-11")
size(P, sAttribute = "text_name")
size(P, sAttribute = "text_party")
size(P, sAttribute = c("text_name", "text_party"))
}
}
\seealso{
See \code{\link{dispersion}}-method for counts of hits. The \code{\link{hits}}
method calls the \code{size}-method to get sizes of subcorpora.
}
