% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{t.polyMatrix}
\alias{t.polyMatrix}
\title{Matrix transpose of a \code{polyMatrix} class object}
\usage{
\method{t}{polyMatrix}(x)
}
\arguments{
\item{x}{\code{polyMatrix} class object}
}
\value{
A '\code{polyMdlist}, \code{polyMatrix}' class object,
the transposed version of the given \code{x} polynomial matrix.
}
\description{
The method first convert the storage method of
the given \code{polyMatrix} object to \code{polyMdlist} class interpretation,
then flips the \code{polyMatrix} over its diagonal.
}
\examples{
m <- matrix(1:12,3,4)
t(m) # the \code{base::t()} function

pa <- polyMgen.a()
pm <- t(pa)
dim(pm) # 3 x 2
class(pm) #  "polyMdlist" "polyMatrix"

}
\seealso{
The \sQuote{\code{t}} in the \code{base} package.
}
