% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{cluster_per_LG}
\alias{cluster_per_LG}
\title{Cluster 1.0 markers into correct homologues per linkage group}
\usage{
cluster_per_LG(LG, linkage_df, LG_hom_stack, LOD_sequence,
  modify_LG_hom_stack = FALSE, nclust_out = NULL,
  network.layout = c("circular", "stacked", "n"), device = NULL,
  label.offset = 1, cex.lab = 0.7, log = NULL, ...)
}
\arguments{
\item{LG}{Integer. Linkage group to investigate.}

\item{linkage_df}{A data.frame as output of \code{\link{linkage}} with arguments \code{markertype1 = c(1,0)} and \code{markertype2=NULL}.}

\item{LG_hom_stack}{A \code{data.frame} with columns \code{"SxN_Marker"} providing 1.0 markernames and \code{"LG"} 
and \code{"homologue"} providing linkage group and homologue respectively.}

\item{LOD_sequence}{A numeric or vector of numerics giving LOD threshold(s) at which clustering should be performed.}

\item{modify_LG_hom_stack}{Logical. Should \code{LG_hom_stack} be modified and returned?}

\item{nclust_out}{Number of clusters in the output. If there are more clusters than this number only the nclust_out largest clusters are returned.}

\item{network.layout}{Network layout: \code{"circular"} or \code{"stacked"}. If \code{"n"} no network is plotted.}

\item{device}{Function of the graphics device to plot to (e.g. \code{\link{pdf}}, \code{\link{png}}, \code{\link{jpeg}}). The active device is used when \code{NULL}}

\item{label.offset}{Offset of labels. Only used if \code{network.layout="circular"}.}

\item{cex.lab}{label character expansion. Only for \code{network.layout="circular"}.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{\dots}{Arguments passed to \code{device}.}
}
\value{
A modified LG_hom_stack \code{data.frame} if \code{modify_LG_hom_stack = TRUE}
}
\description{
Clustering at one LOD score for all markers does usually not result in correct classification of homologues. Usually there are more clusters of (pseudo)homologues than expected. This function lets you inspect every linkage group separately and allows for clustering at a different LOD threshold per LG.
}
\examples{
data("SN_SN_P2", "LGHomDf_P2_1")
#take only markers in coupling:
SN_SN_P2_coupl <- SN_SN_P2[SN_SN_P2$phase=="coupling",]
cluster_per_LG(LG = 2,
               linkage_df=SN_SN_P2_coupl,
               LG_hom_stack=LGHomDf_P2_1,
               LOD_sequence=seq(4,10,2),
               modify_LG_hom_stack=FALSE,
               nclust_out=4,
               network.layout="circular",
               device=NULL,
               label.offset=1.2,
               cex.lab=0.75)
}
