% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{calcSegtypeInfo}
\alias{calcSegtypeInfo}
\title{Build a list of segregation types}
\usage{
calcSegtypeInfo(ploidy, ploidy2=NULL)
}
\arguments{
\item{ploidy}{The ploidy of parent 1 (must be even, 2 (diploid) or larger).}

\item{ploidy2}{The ploidy of parent 2. If omitted (default=NULL) it is
assumed to be equal to ploidy.}
}
\value{
A list with for each different segregation type (segtype) one item.
The names of the items are the names of the segtypes.
Each item is itself a list with components:
\itemize{
\item{freq}{a vector of the ploidy+1 fractions of the dosages in the F1}
\item{intratios}{an integer vector with the ratios as the simplest integers}
\item{expgeno}{a vector with the dosages present in this segtype}
\item{allfrq}{the allele frequency of the dosage allele in the F1}
\item{polysomic}{boolean: does this segtype occur with polysomic inheritance?}
\item{disomic}{boolean: does this segtype occur with disomic inheritance?}
\item{mixed}{boolean: does this segtype occur with mixed inheritance (i.e. with
polysomic inheritance in one parent and disomic inheritance in the other)?}
\item{pardosage}{integer matrix with 2 columns and as many rows as there
are parental dosage combinations for this segtype;
each row has one possible combination of dosages for
parent 1 (1st column) and parent 2 (2nd column)}
\item{parmode}{logical matrix with 3 columns and the same number of rows as
pardosage. The 3 columns are named polysomic, disomic and mixed and
tell if this parental dosage combination will generate this
segtype under polysomic, disomic and mixed inheritance}
}
}
\description{
For each possible segregation type in an F1 progeny with given
parental ploidy (and ploidy2, if parent2 has a different ploidy than parent1)
information is given on the segregation ratios, parental dosages and whether
the segregation is expected under polysomic, disomic and/or mixed inheritance.
}
\details{
The names of the segregation types consist of a short sequence of
digits (and sometimes letters), an underscore and a final number. This is
interpreted as follows, for example segtype 121_0: 121 means that there
are three consecutive dosages in the F1 population with frequency ratios 1:2:1,
and the 0 after the underscore means that the lowest of these dosages is
nulliplex. So 121_0 means a segregation of 1 nulliplex : 2 simplex : 1 duplex.
A monomorphic F1 (one single dosage) is indicated as e.g. 1_4 (only one
dosage, the 4 after the underscore means that this is monomorphic quadruplex).
If UPPERCASE letters occur in the first part of the name these are interpreted
as additional digits with values of A=10 to Z=35, e.g. 18I81_0 means a
segregation of 1:8:18:8:1 (using the I as 18), with the lowest dosage being
nulliplex.\cr
With higher ploidy levels higher numbers (above 35) may be required.
In that case each unique ratio number above 35 is assigned a lowercase letter.
E.g. one segregation type in octaploids is 9bcb9_2: a 9:48:82:48:9
segregation where the lowest dosage is duplex.\cr
Segregation types with more than 5 dosage classes are considered "complex"
and get codes like c7e_1 (again in octoploids): this means a complex type
(the first c) with 7 dosage classes; the e means that this is the fifth
type with 7 classes. Again the _1 means that the lowest dosage is simplex.
It is always possible (and for all segtype names with lowercase letters it is
necessary) to look up the actual segregation ratios in the intratio item
of the segtype. For octoploid segtype c7e_1 this shows 0:1:18:69:104:69:18:1:0
(the two 0's mean that nulli- and octoplexes do not occur).
}
\examples{
si4 <- calcSegtypeInfo(ploidy=4) # two 4x parents: a 4x F1 progeny
print(si4[["11_0"]])

si3 <- calcSegtypeInfo(ploidy=4, ploidy2=2) # a 4x and a diplo parent: a 3x progeny
print(si3[["11_0"]])
}
