% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pomp-package.R
\docType{package}
\name{pomp-package}
\alias{pomp-package}
\alias{pomp,package}
\title{Inference for partially observed Markov processes}
\description{
The \pkg{pomp} package provides facilities for inference on time series
data using partially-observed Markov process (\acronym{POMP}) models.
These models are also known as state-space models, hidden Markov models, or
nonlinear stochastic dynamical systems.  One can use \pkg{pomp} to fit
nonlinear, non-Gaussian dynamic models to time-series data.  The package is
both a set of tools for data analysis and a platform upon which statistical
inference methods for \acronym{POMP} models can be implemented.
}
\section{Data analysis using \pkg{pomp}}{

\pkg{pomp} provides algorithms for
\enumerate{
\item simulation of stochastic
dynamical systems; see \code{\link[=simulate-pomp]{simulate}}
\item
particle filtering (AKA sequential Monte Carlo or sequential importance
sampling); see \code{\link{pfilter}}
\item the iterated filtering methods
of Ionides et al. (2006, 2011, 2015); see \code{\link{mif2}}
\item the
nonlinear forecasting algorithm of Kendall et al. (2005); see
\code{\link{nlf}}
\item the particle MCMC approach of Andrieu et al. (2010); see \code{\link{pmcmc}}
\item the probe-matching method of Kendall et al. (1999, 2005); see \code{\link{probe.match}}
\item a spectral probe-matching method (Reuman et al. 2006, 2008); see
\code{\link{spect.match}}
\item synthetic likelihood a la Wood (2010); see \code{\link{probe}}
\item approximate Bayesian computation (Toni et al. 2009); see \code{\link{abc}}
\item the approximate Bayesian sequential
Monte Carlo scheme of Liu & West (2001); see \code{\link{bsmc2}}
\item ensemble and ensemble adjusted Kalman filters; see \code{\link{kalman}}
\item simple trajectory matching; see \code{\link{traj.match}}.
}
The package
also provides various tools for plotting and extracting information on
models and data.
}

\references{
\King2016

See the package website, \url{https://kingaa.github.io/pomp/}, for more
references.
}
\seealso{
Other information on model implementation: 
\code{\link{Csnippet}},
\code{\link{accumulators}},
\code{\link{covariate_table}()},
\code{\link{distributions}},
\code{\link{dmeasure_spec}},
\code{\link{dprocess_spec}},
\code{\link{parameter_trans}()},
\code{\link{prior_spec}},
\code{\link{rinit_spec}},
\code{\link{rmeasure_spec}},
\code{\link{rprocess_spec}},
\code{\link{skeleton_spec}},
\code{\link{transformations}},
\code{\link{userdata}}

Other pomp parameter estimation methods: 
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{probe.match}},
\code{\link{spect.match}}

Other elementary POMP methods: 
\code{\link{pfilter}()},
\code{\link{probe}()},
\code{\link{simulate}()},
\code{\link{spect}()}
}
\author{
Aaron A. King
}
\concept{elementary POMP methods}
\concept{information on model implementation}
\concept{pomp parameter estimation methods}
\keyword{models}
\keyword{multivariate}
\keyword{ts}
