% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{flow}
\alias{flow}
\alias{flow,missing-method}
\alias{flow,ANY-method}
\alias{flow-pomp}
\alias{flow,pomp-method}
\title{Flow of a deterministic model}
\usage{
\S4method{flow}{pomp}(object, x0, t0, times, params, ..., verbose = getOption("verbose", FALSE))
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x0}{an array with dimensions \code{nvar} x \code{nrep} giving the initial conditions of the trajectories to be computed.}

\item{t0}{the time at which the initial conditions are assumed to hold.}

\item{times}{a numeric vector (length \code{ntimes}) containing times at which the itineraries are desired.
These must be in non-decreasing order with \code{times[1]>t0}.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{Additional arguments are passed to the ODE integrator (if the skeleton is a vectorfield) and are ignored if it is a map.
See \code{\link[deSolve]{ode}} for a description of the additional arguments accepted by the ODE integrator.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{flow} returns an array of dimensions \code{nvar} x \code{nrep} x \code{ntimes}.
If \code{x} is the returned matrix, \code{x[i,j,k]} is the i-th component of the state vector at time \code{times[k]} given parameters \code{params[,j]}.
}
\description{
Compute the flow induced by a deterministic vectorfield or map.
}
\details{
In the case of a discrete-time system (map), \code{flow} iterates the map to yield trajectories of the system.
In the case of a continuous-time system (vectorfield), \code{flow} uses the numerical solvers in \pkg{\link[deSolve]{deSolve}} to integrate the vectorfield starting from given initial conditions.
}
\seealso{
\code{\link{skeleton}}, \code{\link{trajectory}}, \code{\link{rprocess}}

Other pomp workhorses: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{partrans}()},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{workhorses}}
}
\concept{pomp workhorses}
