% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcap.R
\name{mcap}
\alias{mcap}
\title{Monte Carlo adjusted profile}
\usage{
mcap(logLik, parameter, level = 0.95, span = 0.75, Ngrid = 1000)
}
\arguments{
\item{logLik}{numeric; a vector of profile log likelihood evaluations.}

\item{parameter}{numeric; the corresponding values of the focal parameter.}

\item{level}{numeric; the confidence level required.}

\item{span}{numeric; the \code{\link[stats]{loess}} smoothing parameter.}

\item{Ngrid}{integer; the number of points to evaluate the smoothed profile.}
}
\value{
\code{mcap} returns a list including the' \code{\link[stats]{loess}}-smoothed
profile, a quadratic approximation, and the constructed confidence interval.
}
\description{
Given a collection of points maximizing the likelihood over a range
of fixed values of a focal parameter, this function constructs 
a profile likelihood confidence interval accommodating both
Monte Carlo error in the profile and statistical uncertainty present
in the likelihood function.
}
\references{
\Ionides2017
}
\author{
Edward L. Ionides
}
\concept{profile likelihood}
