% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmat.R
\name{covmat}
\alias{covmat}
\alias{covmat,missing-method}
\alias{covmat,ANY-method}
\alias{covmat,pmcmcd_pomp-method}
\alias{covmat,pmcmcList-method}
\alias{covmat,abcd_pomp-method}
\alias{covmat,abcList-method}
\alias{covmat,probed_pomp-method}
\title{Estimate a covariance matrix from algorithm traces}
\usage{
\S4method{covmat}{pmcmcd_pomp}(object, start = 1, thin = 1, expand = 2.38, ...)

\S4method{covmat}{pmcmcList}(object, start = 1, thin = 1, expand = 2.38, ...)

\S4method{covmat}{abcd_pomp}(object, start = 1, thin = 1, expand = 2.38, ...)

\S4method{covmat}{abcList}(object, start = 1, thin = 1, expand = 2.38, ...)

\S4method{covmat}{probed_pomp}(object, ...)
}
\arguments{
\item{object}{an object extending \sQuote{pomp}}

\item{start}{the first iteration number to be used in estimating the covariance matrix.
Setting \code{thin > 1} allows for a burn-in period.}

\item{thin}{factor by which the chains are to be thinned}

\item{expand}{the expansion factor}

\item{\dots}{ignored}
}
\value{
When \code{object} is the result of a \code{pmcmc} or \code{abc} computation,
\code{covmat(object)} gives the covariance matrix of the chains.
This can be useful, for example, in tuning the proposal distribution.

When \code{object} is a \sQuote{probed_pomp} object (i.e., the result
of a \code{probe} computation), \code{covmat(object)} returns the
covariance matrix of the probes, as applied to simulated data.
}
\description{
A helper function to extract a covariance matrix.
}
\seealso{
\link[=proposals]{MCMC proposals}.

Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond_logLik}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{time}()},
\code{\link{timezero}()},
\code{\link{traces}()}
}
\concept{extraction methods}
