% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooldata2diyabc.R
\name{pooldata2diyabc}
\alias{pooldata2diyabc}
\title{Convert a pooldata object into DIYABC input files.}
\usage{
pooldata2diyabc(
  pooldata,
  writing.dir = getwd(),
  prefix = "",
  diyabc.mrc = 1,
  subsamplesize = -1,
  subsamplingmethod = "thinning"
)
}
\arguments{
\item{pooldata}{A pooldata object containing Pool-Seq information (see \code{\link{vcf2pooldata}} and \code{\link{popsync2pooldata}})}

\item{writing.dir}{Directory where to create the files  (e.g., set writing.dir=getwd() to copy in the current working directory)}

\item{prefix}{Prefix used for output file names}

\item{diyabc.mrc}{MRC to be applied by DIYABC (note that no filtering based on MRC is done by the function)}

\item{subsamplesize}{Size of the sub-samples. If <=1 (default), all the SNPs are considered in the output}

\item{subsamplingmethod}{If sub-sampling is activated (argument subsamplesize), define the method used for subsampling that might be either i) "random" (A single data set consisting of randmly chosen SNPs is generated) or ii) "thinning", sub-samples are generated by taking SNPs one every nsub=floor(nsnp/subsamplesize) in the order of the map (a suffix ".subn" is added to each sub-sample files where n varies from 1 to nsub).}
}
\value{
DIYABC data file for pool-seq data
}
\description{
Convert a pooldata object into DIYABC data file for pool-seq data. A file containing SNP details is also printed out. Options to generate sub-samples  (e.g., for large number of SNPs) are also available. Note that DIYABC SNP filtering criterion is based on MRC (minimal read count) which may be more stringent than usual MAF-based filtering criterion. It is recommended to parse vcf files and pooldata objects without any MAF criterion or to prefilter pooldata objects with the desired MRC (using option snp.index \code{\link{pooldata.subset}}).
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 pooldata2diyabc(pooldata=pooldata,writing.dir=tempdir())
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}}
}
