% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_logreg_xerrors2.R
\name{p_logreg_xerrors2}
\alias{p_logreg_xerrors2}
\title{Poolwise Logistic Regression with Gamma Exposure Subject to Errors}
\usage{
p_logreg_xerrors2(g = NULL, y, xtilde, c = NULL, errors = "both",
  nondiff_pe = TRUE, nondiff_me = TRUE, constant_pe = TRUE, prev = NULL,
  samp_y1y0 = NULL, integrate_tol = 1e-08,
  integrate_tol_start = integrate_tol,
  integrate_tol_hessian = integrate_tol, estimate_var = TRUE, ...)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector with poolwise \code{Y} values, coded 0 if all members
are controls and 1 if all members are cases.}

\item{xtilde}{Numeric vector (or list of numeric vectors, if some pools have
replicates) with \code{Xtilde} values.}

\item{c}{List where each element is a numeric matrix containing the
\strong{\code{C}} values for members of a particular pool (1 row for each
member).}

\item{errors}{Character string specifying the errors that \code{X} is subject
to. Choices are \code{"neither"}, \code{"processing"} for processing error
only, \code{"measurement"} for measurement error only, and \code{"both"}.}

\item{nondiff_pe}{Logical value for whether to assume the processing error
variance is non-differential, i.e. the same in case pools and control pools.}

\item{nondiff_me}{Logical value for whether to assume the measurement error
variance is non-differential, i.e. the same in case pools and control pools.}

\item{constant_pe}{Logical value for whether to assume the processing error
variance is constant with pool size. If \code{FALSE}, assumption is that
processing error variance increase with pool size such that, for example, the
processing error affecting a pool 2x as large as another has 2x the variance.}

\item{prev}{Numeric value specifying disease prevalence, allowing
for valid estimation of the intercept with case-control sampling. Can specify
\code{samp_y1y0} instead if sampling rates are known.}

\item{samp_y1y0}{Numeric vector of length 2 specifying sampling probabilities
for cases and controls, allowing for valid estimation of the intercept with
case-control sampling. Can specify \code{prev} instead if it's easier.}

\item{integrate_tol}{Numeric value specifying the \code{tol} input to
\code{\link{adaptIntegrate}}.}

\item{integrate_tol_start}{Same as \code{integrate_tol}, but applies only to
the very first iteration of ML maximization. The first iteration tends to
take much longer than subsequent ones, so less precise integration at the
start can speed things up.}

\item{integrate_tol_hessian}{Same as \code{integrate_tol}, but for use when
estimating the Hessian matrix only. Sometimes more precise integration
(i.e. smaller tolerance) than used for maximizing the likelihood helps
prevent cases where the inverse Hessian is not positive definite.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Assumes constant-scale Gamma model for exposure given covariates, and
multiplicative lognormal processing errors and measurement errors acting on
the poolwise mean exposure. Manuscript fully describing the approach is
under review.
}
\examples{
# Load datasets - pdat2 has poolwise (Y, Xtilde) values and pdat2_c has
# individual-level C values. Xtilde values are affected by processing error.
data(pdat2)
data(pdat2_c)

# Estimate log-OR for X and Y adjusted for C, ignoring processing error
fit1 <- p_logreg_xerrors2(g = pdat2$g, y = pdat2$y, xtilde = pdat2$xtilde,
                          c = pdat2_c, errors = "neither")
fit1$theta.hat

# Repeat, but accounting for processing error. Takes about 1 minute to run
# due to numerical integration. Gives log-OR closer to true value of 0.5.
# fit2 <- p_logreg_xerrors2(g = pdat2$g, y = pdat2$y, xtilde = pdat2$xtilde,
#                           c = pdat2_c, errors = "processing",
#                           control = list(trace = 1))
# fit2$theta.hat


}
\references{
Mitchell, E.M, Lyles, R.H., and Schisterman, E.F. (2015) "Positing, fitting,
and selecting regression models for pooled biomarker data." \emph{Stat. Med}
\strong{34}(17): 2544--2558.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.

Weinberg, C.R. and Umbach, D.M. (1999) "Using pooled exposure assessment to
improve efficiency in case-control studies." \emph{Biometrics} \strong{55}:
718--726.

Weinberg, C.R. and Umbach, D.M. (2014) "Correction to 'Using pooled exposure
assessment to improve efficiency in case-control studies' by Clarice R.
Weinberg and David M. Umbach; 55, 718--726, September 1999."
\emph{Biometrics} \strong{70}: 1061.

Whitcomb, B.W., Perkins, N.J., Zhang, Z., Ye, A., and Lyles, R. H. (2012)
"Assessment of skewed exposure in case-control studies with pooling."
\emph{Stat. Med.} \strong{31}: 2461--2472.
}
