% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\alias{summarize}
\title{Reduce multiple values down to a single value}
\usage{
summarise(.data, ...)

summarize(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Name-value pairs of summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length \code{1}, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A vector of length \code{n}, e.g. \code{quantile()}.
}}
}
\description{
Create one or more scalar variables summarising the variables of an existing \code{data.frame}. Grouped \code{data.frame}s will
result in one row in the output for each group.
}
\details{
\code{summarise()} and \code{summarize()} are synonyms.
}
\examples{
summarise(mtcars, mean(mpg))
summarise(mtcars, meanMpg = mean(mpg), sumMpg = sum(mpg))
mtcars \%>\% summarise(mean(mpg))

}
