% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Pbear}
\alias{Pbear}
\title{Polar bear matrices}
\format{List object containing matrices.}
\usage{
data(Pbear)
}
\description{
Matrix projection model for the polar bear \emph{Ursus maritimus}, with 
5 matrices corresponding to years 2001-2005. The matrices are based on a 
population in the southern Beaufort Sea. During 2001-2003, ice conditions were
classified as "good", but in 2004-2005, ice conditions were classified as 
"poor". Poor ice conditions lead to worse population performance. Stages are 
based on age and 
reproductive status:\cr
Stage-1: 2-year-old\cr
Stage 2: 3-year-old\cr
Stage 3: 4-year-old\cr
Stage 4: adult (5+ years old), available to breed\cr
Stage 5: adult, with cub (0-1 years old)\cr
Stage 6: adult, with yearling (1-2 years old).
}
\details{
The population structure is 
\code{c(0.106, 0.068, 0.106, 0.461, 0.151, 0.108))}
}
\examples{
  #read in data
  data(Pbear)
  Pbear

}
\references{
\itemize{
 \item Hunter et al. (2010) Ecology, 91, 2883-2897.
}
}
\concept{
data polar bear matrix Ursus maritimus
}
\keyword{datasets}
