% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymous.R
\name{anonymous}
\alias{anonymous}
\title{anonymous}
\usage{
anonymous(data, ID, string_length = 15, SEED = NULL)
}
\arguments{
\item{data}{data.frame. A dataset with the a variable to change its values.}

\item{ID}{character. A string with the variable name to change its values.}

\item{string_length}{numeric. It defines the string length of the new identification variable.}

\item{SEED}{to be passed to \code{\link{set.seed}} to keep the the same new id's.}
}
\value{
\code{anonymous} function returns a list with two data frames:
\item{data}{original data with the new variable}
\item{dictionary}{data frame with the original variable and the new one}
}
\description{
Anonymizing a data frame by avoiding vulnerability to a rainbow table attack.
}
\examples{

library(dplyr)
df <- select(mutate(mtcars, id=rownames(mtcars)), id, !contains("id"))
anonymous(df, ID="id", string_length = 5, SEED=160589)


}
\references{
\insertRef{anonymous}{popstudy}
}
\author{
Cesar Gamboa-Sanabria
}
